
/* GTK UI code for Xtheater - Provides Dialog for Opening arbitrary strings

   Copyright (C) 2000 Jarrod Johnson

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   Author may be contacted at jbjohns4@eos.ncsu.edu
*/

/* Routines to handle URL related functions */

#include <string.h>
#include "gtk-ui.h"
void open_dialog (GtkWidget * w, ui_data * m)
{
   strcpy (m->name, gtk_entry_get_text (GTK_ENTRY (m->text)));
   gtk_widget_destroy (m->dialog);
   ui_open (m);
}

void close_dialog (GtkWidget * w, ui_data * m)
{
   gtk_widget_destroy (m->dialog);
}

void open_url (GtkWidget * w, ui_data * m)
{
   GtkWidget *the_label;
   GtkWidget *okbutton;
   GtkWidget *notokbutton;

   m->dialog = gtk_dialog_new ();
   m->text = gtk_entry_new_with_max_length (PATH_MAX + 9);
   the_label = gtk_label_new ("Enter url:");
   gtk_entry_set_text (GTK_ENTRY (m->text), "http://");
   gtk_entry_set_position (GTK_ENTRY (m->text), 7);
   okbutton = gtk_button_new_with_label ("Ok");
   notokbutton = gtk_button_new_with_label ("Cancel");
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (m->dialog)->vbox), the_label, 0,
                       0, 0);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (m->dialog)->vbox), m->text, 0, 0,
                       0);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (m->dialog)->action_area),
                       okbutton, 0, 0, 0);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (m->dialog)->action_area),
                       notokbutton, 0, 0, 0);
   gtk_signal_connect (GTK_OBJECT (okbutton), "clicked",
                       GTK_SIGNAL_FUNC (open_dialog), m);

   gtk_signal_connect (GTK_OBJECT (notokbutton), "clicked",
                       GTK_SIGNAL_FUNC (close_dialog), m);
   gtk_widget_show (okbutton);
   gtk_widget_show (notokbutton);
   gtk_widget_show (the_label);
   gtk_widget_show (m->text);
   gtk_widget_show (m->dialog);
}
