
/* GTK UI code for Xtheater - Supplemental functions.

   Copyright (C) 2000 Jarrod Johnson

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   Author may be contacted at jbjohns4@eos.ncsu.edu
*/

/* Various utility functions to accomplish relatively specialized tasks */
#include <stdio.h>
#include "gtk-ui.h"

/* Provides Generic dialog that displays a string, nothing more */
int ui_dialog (char *mess)
{
   GtkWidget *big_box;
   GtkWidget *ok;
   GtkWidget *text;

   ok = gtk_button_new_with_label ("Dismiss");
   text = gtk_label_new (mess);
   big_box = gtk_dialog_new ();
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (big_box)->action_area),
                       ok, TRUE, FALSE, 10);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (big_box)->vbox), text, TRUE, TRUE,
                       0);
   gtk_signal_connect_object (GTK_OBJECT (ok), "clicked",
                              GTK_SIGNAL_FUNC (gtk_widget_destroy),
                              GTK_OBJECT (big_box));
   gtk_widget_show_all (big_box);
   return 0;
}

/* Wrapper for the show and hide functions */
void ui_widget_set_visible (GtkWidget * w, guint32 show)
{
   if (show)
      gtk_widget_show_all (w);
   else
      gtk_widget_hide (w);
}

int ui_activate() {
	fprintf(stderr,"Activate called");
	gdk_window_raise(ui->window->window);
}
int ui_deactivate() {
	fprintf(stderr,"Deactivate called");
	gdk_window_lower(ui->window->window);
}

/* Callback function for Info/About From menu */
void ui_about (GtkObject * junk)
{
   ui_dialog ("Xtheater " VERSION
              "\n\nJarrod Johnson\n\n  Website: http://Xtheater.sourceforge.net/  ");
}

static int user_seek = 0;

void ui_stop_track (GtkObject * w, ui_data * m)
{
   user_seek = 1;
//      fprintf(fprintf,"Seekbar should not be moved..");
}

void ui_start_track (GtkObject * w, ui_data * m)
{
   user_seek = 0;
   loader_seek (GTK_ADJUSTMENT (ui->seek_position)->value);
}

/* Function to refresh UI info displays  */
gint ui_update_info (gpointer md)
{
	/* All returns must be non-zero for the gtk timer */
   ui_data *m = (ui_data *) md;
   static char temp[32];

	if (!m->features)
		return 42;
   m->updating = 1;
   if (!user_seek)
      gtk_adjustment_set_value (GTK_ADJUSTMENT (m->seek_position),
                                loader_get_position ());
   ui_widget_set_visible (m->play_button, !loader_is_playing ());
   ui_widget_set_visible (m->pause_button, loader_is_playing ());
   if (loader_is_atend ()) {
      if (m->play_expected) {
         GtkWidget *j;

         ui_rw (j);
         if (m->looping) {
            ui_play (m->play_button, m);
         } else {
            gtk_adjustment_set_value (GTK_ADJUSTMENT (m->seek_position), 0);
            gtk_widget_hide (m->pause_button);
            if (m->features & CAN_PLAY)
               gtk_widget_show (m->play_button);
         }
      }
      return 42;
   }
   snprintf (temp, 30, "FPS: %2.2f", loader_get_fps ());
   gtk_label_set_text (GTK_LABEL (m->fps_label), temp);
   snprintf (temp, 30, "Frame: %d", loader_get_frame ());
   gtk_label_set_text (GTK_LABEL (m->frame_label), temp);
   m->updating = 0;
   return 42;
}

int ui_shutodwn ()
{
   ui_exit (0);
}

void ui_exit (GtkWidget * w)

/* Exit program */
{
   gtk_main_quit ();
   loader_exit ();
   screensaver_restore (GDK_DISPLAY ());
}

int ui_close_media ()
{
   //Function to be called externally when media closes itself
   ui->features = 0;
   ui_reconfig (ui);
   gtk_label_set_text (GTK_LABEL (ui->name_label), "No Media Open");
   return 1;
}

int ui_close (GtkWidget * w, ui_data * m)

/* Close current media */
{
   gtk_label_set_text (GTK_LABEL (m->name_label), "No Media Open");
   loader_close ();
   m->features = 0;
   ui_reconfig (m);
   return 0;
}

void ui_mute (GtkWidget * w, ui_data * m)
{
   if (GTK_TOGGLE_BUTTON (w)->active) {
      m->last_volume = GTK_ADJUSTMENT (m->volume_position)->value;
      gtk_adjustment_set_value (GTK_ADJUSTMENT (m->volume_position), 0);
   } else
      gtk_adjustment_set_value (GTK_ADJUSTMENT (m->volume_position),
                                m->last_volume);
}

void ui_set_volume (GtkWidget * w, ui_data * m)
{
   loader_set_volume (GTK_ADJUSTMENT (m->volume_position)->value);
}
