#include "loader.h"

int load_ui (int *argc, char **argv[])
{
   GModule *ui_module;
   loader_func_struct f;
	GString* module_path;
   int (*ui_init) (int *, char **argv[]);
   void (*assign) (loader_func_struct l);
	module_path = g_string_new(NULL);
#ifdef USE_APPDIR
	g_string_sprintf(module_path,"%s/Xtheater/ui",g_getenv("APPDIR"));
#else
	g_string_assign(module_path,top_loader_get_setting("UI_Module_Path"));
#endif

   ui_module =
      g_module_open (g_module_build_path
                     (module_path->str,
                      top_loader_get_setting ("UI_Module")
                     ), 0);
   if (!ui_module) {
      fprintf (stderr, "Unable to open UI Module: \n%s\n", g_module_error ());
      exit (1);
   }
   f.isplay = &top_loader_is_playing;
   f.isatend = &top_loader_is_atend;
   f.play = &top_loader_play;
   f.pause = &top_loader_pause;
   f.stop = &top_loader_stop;
   f.ff = &top_loader_ff;
   f.rw = &top_loader_rw;
   f.prev = &top_loader_prev;
   f.next = &top_loader_next;
   f.loop = &top_loader_loop;
   f.setvol = &top_loader_set_volume;
   f.getvol = &top_loader_get_volume;
   f.getmaxvol = &top_loader_get_max_volume;
   f.seek = &top_loader_seek;
	f.gettime = &top_loader_get_time;
	f.getmaxtime = &top_loader_get_max_time;
   f.getpos = &top_loader_get_position;
   f.getmaxpos = &top_loader_get_max_position;
   f.doubles = &top_loader_double;
   f.fullscreen = &top_loader_fullscreen;
   f.height = &top_loader_get_height;
   f.width = &top_loader_get_width;
   f.frame = &top_loader_get_frame;
   f.fps = &top_loader_get_fps;
   f.open = &top_loader_open;
   f.close = &top_loader_close;
   f.lexit = &top_loader_exit;
   f.wrtcfg = &top_loader_write_config;
   f.setass = &top_loader_set_assoc;
   f.setset = &top_loader_set_setting;
   f.getset = &top_loader_get_setting;
   f.getplugset = &top_loader_get_player_settings;
   f.actplugset = top_loader_activate_settings;
   f.geterr = top_loader_get_error;
   if (g_module_symbol (ui_module, "assign_funcs", (gpointer *) & assign))
      assign (f);
   g_module_symbol (ui_module, "ui_shutdown", (gpointer *) & top_ui_shutdown);
   g_module_symbol (ui_module, "ui_activate", (gpointer *) & top_ui_activate);
   g_module_symbol (ui_module, "ui_deactivate",
                    (gpointer *) & top_ui_deactivate);
   g_module_symbol (ui_module, "ui_close_media",
                    (gpointer *) & top_ui_close_media);
   if (g_module_symbol (ui_module, "ui_init", (gpointer *) & ui_init));
   ui_init (argc, argv);
   return 0;
}
