
/* Primary portion of Xtheater, contains main and loads plugins */
#ifndef _LOADER_H
#define _LOADER_H
#ifdef HAVE_CONFIG_H
#include "../config.h"
#endif
#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include <glib.h>
#include <gmodule.h>
#include <fnmatch.h>
#include "../plugins/plugin_defs.h"

#define MAX_PLAYERS 32
#define MAX_SETTINGS 32
#define MAX_ASSOCIATIONS 32
int num_settings;
char *setting_vals[MAX_SETTINGS];
char *setting_keys[MAX_SETTINGS];

int num_players;
char *players[MAX_PLAYERS];
char *associations[MAX_ASSOCIATIONS];

guint32 features;

/* the player plugin */
GModule *player;

/* symbols to be mapped to ui plugin */
int (*top_ui_activate) ();
int (*top_ui_deactivate) ();
int (*top_ui_close_media) ();
int (*top_ui_shutdown) ();

/* symbols to be mapped to the player plugin */
typedef struct {
   void (*top_player_play) ();
   int (*top_player_is_playing) ();
   int (*top_player_is_atend) ();
   void (*top_player_pause) ();
   void (*top_player_ff) ();
   void (*top_player_rw) ();
   void (*top_player_next) ();
   void (*top_player_prev) ();
   void (*top_player_stop) ();
   void (*top_player_seek) (float position);
	int (*top_player_get_time)();
	int (*top_player_get_max_time)();
   float (*top_player_get_position) ();
   float (*top_player_get_max_position) ();
   void (*top_player_set_volume) (float volume);
   float (*top_player_get_volume) ();
   float (*top_player_get_max_volume) ();
   void (*top_player_loop) ();
   void (*top_player_double) (int val);
   void (*top_player_fullscreen) ();
   int (*top_player_get_height) ();
   int (*top_player_get_width) ();
   int (*top_player_get_frame) ();
   float (*top_player_get_fps) ();
   void (*top_player_close) ();
   char **(*top_player_get_settings) ();
   char *(*top_player_get_error) ();
   void (*top_player_activate_settings) ();
} player_func_struct;

player_func_struct play[MAX_PLAYERS];
int mycount;

/* functions that will be pushed to the UI plugin */
int top_loader_is_playing ();
int top_loader_is_atend ();
void top_loader_play ();
void top_loader_pause ();
void top_loader_stop ();
void top_loader_ff ();
void top_loader_rw ();
void top_loader_prev ();
void top_loader_next ();
void top_loader_loop ();
void top_loader_set_volume (float vol);
float top_loader_get_volume ();
float top_loader_get_max_volume ();
void top_loader_seek (float position);
int top_loader_get_time();
int top_loader_get_max_time();
float top_loader_get_position ();
float top_loader_get_max_position ();
void top_loader_double (int val);
void top_loader_fullscreen ();
int top_loader_get_height ();
int top_loader_get_width ();
int top_loader_get_frame ();
float top_loader_get_fps ();
guint32 top_loader_open (char *name);
void top_loader_close ();
void top_loader_exit ();
char *top_loader_get_setting (char *key);
void top_loader_set_assoc (char *type, char *plug);
void top_loader_set_setting (char *key, char *val);
void top_loader_write_config ();
char *top_loader_get_error ();
char **top_loader_get_player_settings ();
void top_loader_activate_settings ();

/* struct to hold all the functions that will be passed to ui plugin */
typedef struct {
   void (*play) ();
   void (*pause) ();
   void (*stop) ();
   void (*ff) ();
   void (*rw) ();
   void (*prev) ();
   void (*next) ();
   void (*loop) ();
   void (*setvol) (float vol);
   float (*getvol) ();
   float (*getmaxvol) ();
   void (*seek) (float position);
	int (*gettime)();
	int (*getmaxtime)();
   float (*getpos) ();
   float (*getmaxpos) ();
   void (*doubles) (int val);
   void (*fullscreen) ();
   int (*height) ();
   int (*width) ();
   int (*frame) ();
   float (*fps) ();
     guint32 (*open) (char *name);
   void (*close) ();
   void (*lexit) ();
   char *(*getset) (char *key);
   void (*setset) (char *key, char *val);
   void (*wrtcfg) ();
   void (*setass) (char *type, char *plug);
   char **(*getplugset) ();
   void (*actplugset) ();
   char *(*geterr) ();
   int (*isplay) ();
   int (*isatend) ();
	int (*act)();
	int (*deact)();
   int (*uishutdown) ();
} loader_func_struct;

int load_ui (int *argc, char **argv[]);
void parse_config (char *filename);
char *user_conf;
char *errorstr;
#endif
