#include "loader.h"

guint32 top_loader_open (char *file)
{
   int count;
   int (*ini) (char *name);

   features = 0;
   count = num_players - 1;
   while (!features) {
      while ((count >= 0) && fnmatch (associations[count], file, 0))
         count--;
      if (count >= 0) {
			GString* plugin_path;
			plugin_path=g_string_new(NULL);
#ifdef USE_APPDIR
			g_string_sprintf(plugin_path,"%s/Xtheater/player",g_getenv("APPDIR"));
#else
			g_string_assign(plugin_path,top_loader_get_setting("Plugin_Path"));
#endif
			
#ifdef DEBUG
         fprintf (stderr, "%s being loaded to play %s\n", players[count], file);
#endif
         player =
            g_module_open (g_module_build_path
                           (plugin_path->str,
                            players[count]), 0);
#ifdef DEBUG
         if (!player)
            fprintf (stderr, "No module? %s\n", g_module_error ());
#endif
         if (player
             && g_module_symbol (player, "player_open", (gpointer *) & ini)) {
            mycount = count;
            load_symbols ();
            features = ini (file);
            if (!features) {
               errorstr = g_strdup (play[mycount].top_player_get_error ());
               return 0;
            }
         } else {
            if (!player)
               errorstr = g_strdup_printf ("Unable to load player %s:\n %s\n",
                                           players[count], g_module_error ());
            else
               errorstr =
                  g_strdup ("Specified player is not an Xtheater Plugin!");
            return 0;
         }
      } else {
         errorstr =
            g_strdup_printf
            ("No matching player association was found for %s", file);
         return 0;
      }
      count--;
   }
   return features;
}
