#include "loader.h"

void parse_config (char *filename)
{
   FILE *file;
   char *temp_line;
   char *temp_key;
   char *temp_val;

   temp_line = (char *) malloc (PATH_MAX + 1);
   temp_key = (char *) malloc (PATH_MAX + 1);
   temp_val = (char *) malloc (PATH_MAX + 1);

   file = fopen (filename, "r");

   if (!file) {
      free (temp_line);
      free (temp_key);
      free (temp_val);
      return;
   }
   while (fgets (temp_line, PATH_MAX, file)) {
      sscanf (temp_line, "%s %s", temp_key, temp_val);
      switch (temp_key[0]) {
         case 0:
            continue;
            break;
         case '#':
            temp_key[0] = 0;
            temp_val[0] = 0;
#ifdef DEBUG
            fprintf (stderr, "Ignoring comment\n");
#endif
            continue;
            break;
         case '|':
            top_loader_set_assoc (temp_key + 1, temp_val);
#ifdef DEBUG
            fprintf (stderr, "%s set to be opened by %s\n", temp_key, temp_val);
#endif
            temp_key[0] = 0;
            temp_val[0] = 0;
            continue;
            break;
         default:
            top_loader_set_setting (temp_key, temp_val);
#ifdef DEBUG
            fprintf (stderr, "Setting found: %s set to %s\n", temp_key,
                     temp_val);
#endif
            temp_key[0] = 0;
            temp_val[0] = 0;
      }
   }

   free (temp_line);
   free (temp_key);
   free (temp_val);
   fclose (file);
}
