#include "smpeg-player.h"
int tcp_open (char *address, int port);
int ftp_get_reply (int tcp_sock)
{
   int i;
   char c;
   char answer[1024];

   do {
      /*
         Read a line 
       */
      for (i = 0, c = 0; i < 1024 && c != '\n'; i++) {
         read (tcp_sock, &c, sizeof (char));
         answer[i] = c;
      }
      answer[i] = 0;
      fprintf (stderr, answer + 4);
   }
   while (answer[3] == '-');

   answer[3] = 0;

   return (atoi (answer));
}

int ftp_open (char *arg)
{
   char *host;
   int port;
   char *dir;
   char *file;
   int tcp_sock;
   int data_sock;
   char ftp_request[1024];
   struct sockaddr_in stLclAddr;
   int i;

   /*
      Check for URL syntax 
    */
   if (strncmp (arg, "ftp://", strlen ("ftp://")))
      return (0);

   /*
      Parse URL 
    */
   port = 21;
   host = arg + strlen ("ftp://");
   if ((dir = strchr (host, '/')) == NULL)
      return (0);
   *dir++ = 0;
   if ((file = strrchr (dir, '/')) == NULL) {
      file = dir;
      dir = NULL;
   } else
      *file++ = 0;

   if (strchr (host, ':') != NULL) {    /* port is specified */
      port = atoi (strchr (host, ':') + 1);
      *strchr (host, ':') = 0;
   }

   /*
      Open a TCP socket 
    */
   if (!(tcp_sock = tcp_open (host, port))) {
      perror ("ftp_open");
      return (0);
   }

   /*
      Send FTP USER and PASS request 
    */
   ftp_get_reply (tcp_sock);
   sprintf (ftp_request, "USER anonymous\r\n");
   send (tcp_sock, ftp_request, strlen (ftp_request), 0);
   if (ftp_get_reply (tcp_sock) != 331)
      return (0);
   sprintf (ftp_request, "PASS smpeguser@\r\n");
   send (tcp_sock, ftp_request, strlen (ftp_request), 0);
   if (ftp_get_reply (tcp_sock) != 230)
      return (0);
   sprintf (ftp_request, "TYPE I\r\n");
   send (tcp_sock, ftp_request, strlen (ftp_request), 0);
   if (ftp_get_reply (tcp_sock) != 200)
      return (0);
   if (dir != NULL) {
      sprintf (ftp_request, "CWD %s\r\n", dir);
      send (tcp_sock, ftp_request, strlen (ftp_request), 0);
      if (ftp_get_reply (tcp_sock) != 250)
         return (0);
   }

   /*
      Get interface address 
    */
   i = sizeof (stLclAddr);
   if (getsockname (tcp_sock, (struct sockaddr *) &stLclAddr, &i) < 0)
      return (0);

   /*
      Open data socket 
    */
   if ((data_sock = socket (PF_INET, SOCK_STREAM, 0)) < 0)
      return (0);

   stLclAddr.sin_family = AF_INET;

   /*
      Get the first free port 
    */
   for (i = 0; i < 0xC000; i++) {
      stLclAddr.sin_port = htons (0x4000 + i);
      if (bind (data_sock, (struct sockaddr *) &stLclAddr, sizeof (stLclAddr))
          >= 0)
         break;
   }
   port = 0x4000 + i;

   if (listen (data_sock, 1) < 0)
      return (0);

   i = ntohl (stLclAddr.sin_addr.s_addr);
   sprintf (ftp_request, "PORT %d,%d,%d,%d,%d,%d\r\n",
            (i >> 24) & 0xFF, (i >> 16) & 0xFF,
            (i >> 8) & 0xFF, i & 0xFF, (port >> 8) & 0xFF, port & 0xFF);
   send (tcp_sock, ftp_request, strlen (ftp_request), 0);
   if (ftp_get_reply (tcp_sock) != 200)
      return (0);

   sprintf (ftp_request, "RETR %s\r\n", file);
   send (tcp_sock, ftp_request, strlen (ftp_request), 0);
   if (ftp_get_reply (tcp_sock) != 150)
      return (0);

   return (accept (data_sock, NULL, NULL));
}
