#include "smpeg-player.h"

/* This function is now a toggle, if in fullscreen, leaves that mode..
 * Otherwise.... enters 
 */
void player_fullscreen ()
{
   if (m->in_fullscreen) {
      m->in_fullscreen = 0;
      m->video_flags = m->video_flags & ~SDL_FULLSCREEN;
      m->width = m->mpeg_info.width;
      m->height = m->mpeg_info.height;
#ifdef USE_GL
      if (!m->gl_all)
         m->video_flags = m->video_flags & ~SDL_OPENGL;
#endif
      setup_screen ();
   } else {
      m->in_fullscreen = 1;
      m->video_flags = m->video_flags | SDL_FULLSCREEN;
      m->width = m->mpeg_info.width;
      m->height = m->mpeg_info.height;
      if (loader_get_setting ("smpeg_scale_fs")
          && !strcmp ("true", loader_get_setting ("smpeg_scale_fs"))) {
#ifdef USE_GL
         if (m->gl_fullscreen)
            m->video_flags = m->video_flags | SDL_OPENGL;
#endif
         m->width = m->screenwidth;
         m->height = m->screenheight;
         if (loader_get_setting ("smpeg_fs_width"))
            sscanf (loader_get_setting ("smpeg_fs_width"), "%d", &m->width);
         if (loader_get_setting ("smpeg_fs_height"))
            sscanf (loader_get_setting ("smpeg_fs_height"), "%d", &m->height);
      }
		if (loader_get_setting("smpeg_fs_preserve_ratio") && !strcmp("true",loader_get_setting("smpeg_fs_preserve_ratio"))) {
			float ratio;
			ratio=(float)m->height/(float)m->mpeg_info.height;
			if ((float)m->width/(float)m->mpeg_info.width < ratio) {
				ratio=(float)m->width/(float)m->mpeg_info.width;
				m->height = m->mpeg_info.height*ratio;
			} else
				m->width = m->mpeg_info.width*ratio;
		}
      setup_screen ();
      loader_play ();
   }
}
