#include "smpeg-player.h"

int player_get_width ()
{
   return m->mpeg_info.width;
}

int player_get_time()
{
   SMPEG_getinfo (m->mpeg, &(m->mpeg_info));
	return  (int)m->mpeg_info.current_time;
}

int player_get_max_time()
{
	return (int)m->mpeg_info.total_time;
}

int player_get_height ()
{
   return m->mpeg_info.height;
}

int player_get_frame ()
{
   SMPEG_getinfo (m->mpeg, &(m->mpeg_info));
   return m->mpeg_info.current_frame;
}

float player_get_fps ()
{
   SMPEG_getinfo (m->mpeg, &(m->mpeg_info));
   return m->mpeg_info.current_fps;
}

float player_get_position ()
{
#ifdef VCD_SUPPORT
   if (m->isvcd)
      return (float) vcd_get_position ();
#endif
   SMPEG_getinfo (m->mpeg, &(m->mpeg_info));
   return (float) m->mpeg_info.current_offset;
}

float player_get_max_position ()
{
#ifdef VCD_SUPPORT
   if (m->isvcd)
      return 100.0;
#endif
   return (float) m->mpeg_info.total_size;
}

int player_is_atend ()
{
   if (m->paused)
      return 0;
   return (player_get_position()==player_get_max_position()) && !((SMPEG_status (m->mpeg) == SMPEG_PLAYING) || (m->isplaying));
}

int player_is_playing ()
{
   return ((SMPEG_status (m->mpeg) == SMPEG_PLAYING) || (m->isplaying));
}

char *player_get_error ()
{
   return m->error;
}
