
/* This file contains rountines dealing with reading mpeg data from network
 * This code is almost entirely from the smpeg projects "plaympeg.c" sample
 * player. */
#include "smpeg-player.h"
int is_address_multicast (unsigned long address)
{
   if ((address & 255) >= 224 && (address & 255) <= 239)
      return (1);
   return (0);
}

int tcp_open (char *address, int port)
{
   struct sockaddr_in stAddr;
   struct hostent *host;
   int sock;
   struct linger l;

   memset (&stAddr, 0, sizeof (stAddr));
   stAddr.sin_family = AF_INET;
   stAddr.sin_port = htons (port);

   if ((host = gethostbyname (address)) == NULL)
      return (0);

   stAddr.sin_addr = *((struct in_addr *) host->h_addr_list[0]);

   if ((sock = socket (AF_INET, SOCK_STREAM, IPPROTO_TCP)) < 0)
      return (0);

   l.l_onoff = 1;
   l.l_linger = 5;
   if (setsockopt (sock, SOL_SOCKET, SO_LINGER, (char *) &l, sizeof (l)) < 0)
      return (0);

   if (connect (sock, (struct sockaddr *) &stAddr, sizeof (stAddr)) < 0)
      return (0);

   return (sock);
}

int udp_open (char *address, int port)
{
   int enable = 1L;
   struct sockaddr_in stAddr;
   struct sockaddr_in stLclAddr;
   struct ip_mreq stMreq;
   struct hostent *host;
   int sock;

   stAddr.sin_family = AF_INET;
   stAddr.sin_port = htons (port);

   if ((host = gethostbyname (address)) == NULL)
      return (0);

   stAddr.sin_addr = *((struct in_addr *) host->h_addr_list[0]);

   /*
      Create a UDP socket 
    */
   if ((sock = socket (AF_INET, SOCK_DGRAM, 0)) < 0)
      return (0);

   /*
      Allow multiple instance of the client to share the same address and port 
    */
   if (setsockopt
       (sock, SOL_SOCKET, SO_REUSEADDR, (char *) &enable,
        sizeof (unsigned long int)) < 0)
      return (0);

   /*
      If the address is multicast, register to the multicast group 
    */
   if (is_address_multicast (stAddr.sin_addr.s_addr)) {
      /*
         Bind the socket to port 
       */
      stLclAddr.sin_family = AF_INET;
      stLclAddr.sin_addr.s_addr = htonl (INADDR_ANY);
      stLclAddr.sin_port = stAddr.sin_port;
      if (bind (sock, (struct sockaddr *) &stLclAddr, sizeof (stLclAddr)) < 0)
         return (0);

      /*
         Register to a multicast address 
       */
      stMreq.imr_multiaddr.s_addr = stAddr.sin_addr.s_addr;
      stMreq.imr_interface.s_addr = INADDR_ANY;
      if (setsockopt
          (sock, IPPROTO_IP, IP_ADD_MEMBERSHIP, (char *) &stMreq,
           sizeof (stMreq)) < 0)
         return (0);
   } else {
      /*
         Bind the socket to port 
       */
      if (bind (sock, (struct sockaddr *) &stAddr, sizeof (stAddr)) < 0)
         return (0);
   }

   return (sock);
}

int raw_open (char *arg)
{
   char *host;
   int port;
   int sock;

   /*
      Check for URL syntax 
    */
   if (strncmp (arg, "raw://", strlen ("raw://")))
      return (0);

   /*
      Parse URL 
    */
   port = 0;
   host = arg + strlen ("raw://");
   if (strchr (host, ':') != NULL) {    /* port is specified */
      port = atoi (strchr (host, ':') + 1);
      *strchr (host, ':') = 0;
   }

   /*
      Open a UDP socket 
    */
   if (!(sock = udp_open (host, port)))
      perror ("raw_open");

   return (sock);
}
