#include "smpeg-player.h"

gchar **player_get_fnmasks ()
{
   static gchar *retval[6];

   retval[0] = g_strdup ("*.[mM][pP][gG]");
   retval[1] = g_strdup ("*.[mM][pP][eE][gG]");
   retval[2] = g_strdup ("/dev/cdrom*");
   retval[3] = g_strdup ("file:/dev/cdrom*");
   retval[4] = g_strdup ("VCD");
   retval[5] = NULL;
   return retval;
}

gchar **player_get_settings ()
{
   static gchar *retval[9];

   if (!m->mpeg_info.has_video)
      return NULL;
   retval[0] =
      g_strdup ("string\tsmpeg_vcd_device\tVCD device");
   retval[1] = 
      g_strdup ("bool\tsmpeg_use_bilinear\tUse Software Bilinear Filter");
   retval[2] =
      g_strdup
      ("bool\tsmpeg_scale_fs\tScale image for fullscreen (See README.Fullscreen");
   retval[3] = g_strdup ("string\tsmpeg_fs_width\tWidth of scaled fullscreen");
   retval[4] =
      g_strdup ("string\tsmpeg_fs_height\tHeight of scaled fullscreen");
	retval[5] = g_strdup("bool\tsmpeg_fs_preserve_ratio\tPreserve aspect ratio in scaled fullscreen");
   retval[6] =
      g_strdup ("string\tsmpeg_seek_time\tTime in seconds that video is seeked in following a fast forward or rewind button press.");
	retval[7] = NULL;
#ifdef USE_GL
   retval[7] =
      g_strdup
      ("bool\tsmpeg_use_gl_fs\tUse OpenGL for scaling fullscreen Renderer (See README.GL)");
   retval[8] =
      g_strdup ("bool\tsmpeg_use_gl\tUse OpenGL for all frame rendering");
   retval[9] = NULL;
#endif
   return (retval);
}

void set_vcd_device ()
{
   if (!(m->vcd_device = loader_get_setting ("smpeg_vcd_device")))
      m->vcd_device = g_strdup ("/dev/cdrom");
}

#ifdef USE_GL
void checkgl ()
{
   if (loader_get_setting ("smpeg_use_gl_fs")
       && !strcmp ("true", loader_get_setting ("smpeg_use_gl_fs")))
      m->gl_fullscreen = 1;
   else
      m->gl_fullscreen = 0;
   if (loader_get_setting ("smpeg_use_gl")
       && !strcmp ("true", loader_get_setting ("smpeg_use_gl"))) {
      m->gl_all = 1;
      m->video_flags = m->video_flags | SDL_OPENGL;
   } else {
      m->gl_all = 0;
      m->video_flags = m->video_flags & ~SDL_OPENGL;
   }
}
#endif

void check_filter ()
{
   SMPEG_Filter *filter;

   if (loader_get_setting ("smpeg_use_bilinear")
       && !strcmp ("true", loader_get_setting ("smpeg_use_bilinear"))) {
      filter = SMPEGfilter_bilinear ();
      filter = SMPEG_filter (m->mpeg, filter);
      filter->destroy (filter);
      return;
   }
   /*
      If we are this far, then assume no filtering 
    */
   filter = SMPEGfilter_null ();
   filter = SMPEG_filter (m->mpeg, filter);
   filter->destroy (filter);
}

void check_usehard ()
{
   if (loader_get_setting ("smpeg_use_hwsurface")
       && !strcmp ("true", loader_get_setting ("smpeg_use_hwsurface")))
      m->video_flags = (m->video_flags & ~SDL_SWSURFACE) | SDL_HWSURFACE;
   else
      m->video_flags = (m->video_flags & ~SDL_HWSURFACE) | SDL_SWSURFACE;
}

void player_activate_settings ()
{
   if (!m->mpeg_info.has_video)
      return;
   m->doing_settings = 1;
   m->video_flags = SDL_RESIZABLE;
	if (loader_get_setting ("smpeg_seek_time")) {
		gchar *local_temp = g_strdup(loader_get_setting("smpeg_seek_time"));
		local_temp = g_strdup(loader_get_setting("smpeg_seek_time"));
		sscanf(local_temp,"%f",&(m->seek_value));
	}
	else
		m->seek_value=10.0;
   check_filter ();
   check_usehard ();
#ifdef USE_GL
   checkgl ();
#endif
   setup_screen ();
   m->doing_settings = 0;
}
