#include "smpeg-player.h"

void player_double (int val)
{
   m->width = (val ? m->mpeg_info.width * 2 : m->mpeg_info.width);
   m->height = (val ? m->mpeg_info.height * 2 : m->mpeg_info.height);
   setup_screen ();
}

void player_close ()
{
   if (!m->file_opened)
      return;
   SDL_RemoveTimer (m->timer_id);
   m->timer_id = 0;
   SDL_QuitSubSystem (SDL_INIT_TIMER);
   if (m->mpeg) {
      if (SMPEG_status (m->mpeg) == SMPEG_PLAYING)
         SMPEG_stop (m->mpeg);
      SMPEG_delete (m->mpeg);
      m->mpeg = 0;
   }
   SDL_QuitSubSystem (SDL_INIT_AUDIO);
   //if (m->screen && m->mpeg_info.has_video) {
   SDL_Quit ();
   //}
}

void player_play ()
{
   if (!m->file_opened)
      return;
   m->paused = 0;
   SMPEG_play (m->mpeg);
}

void player_pause ()
{
   if (!m->file_opened)
      return;
   if (!m->paused) {
      SMPEG_stop (m->mpeg);
      m->paused = 1;
   } else {
      SMPEG_play (m->mpeg);
      m->paused = 0;
   }
}

void player_set_volume (float vol)
{
   SMPEG_setvolume (m->mpeg, (int) vol);
}

float player_get_volume ()
{
   return (float) m->volume;
}

float player_get_max_volume ()
{
   return 100.0;
}

void player_stop ()
{
   SMPEG_pause (m->mpeg);
   SMPEG_rewind (m->mpeg);
   if (m->mpeg_info.has_video) {
      SMPEG_renderFrame (m->mpeg, 1);
   }
}

void player_loop ()
{
   SMPEG_loop (m->mpeg, (m->loop = !(m->loop)));
}

void player_rw ()
{
	double offadj;
	int new_byte;
	offadj = (double)m->mpeg_info.total_size/m->mpeg_info.total_time*m->seek_value;
	new_byte = (int)m->mpeg_info.current_offset-offadj;
	if (new_byte < 0) {
		SMPEG_seek(m->mpeg,0);
	} else
	   SMPEG_seek(m->mpeg,(int)m->mpeg_info.current_offset-offadj);
}

void player_ff ()
{
	//Behavior change, now fast forward by five seconds
	double offadj;
	int new_byte;
	offadj = (double)m->mpeg_info.total_size/m->mpeg_info.total_time*m->seek_value;
	new_byte = (int)m->mpeg_info.current_offset+offadj;
	if (!(new_byte > m->mpeg_info.total_size))
	   SMPEG_seek(m->mpeg,(int)m->mpeg_info.current_offset+offadj);
}

void player_seek (float pos)
{
#ifdef VCD_SUPPORT
   if (m->isvcd) {
      vcd_seek ((int) pos);
      return;
   }
#endif
   SMPEG_seek (m->mpeg, (float) pos);
}
