/* This file contains the code for setting up function pointers properly. */
extern "C" {
#include "../player.h"
};
typedef struct {
   void (*play) ();
   void (*pause) ();
   void (*stop) ();
   void (*ff) ();
   void (*rw) ();
   void (*prev) ();
   void (*next) ();
   void (*loop) ();
   void (*setvol) (float vol);
   float (*getvol) ();
   float (*getmaxvol) ();
   void (*seek) (float position);
	int (*gettime) ();
	int (*getmaxtime)();
   float (*getpos) ();
   float (*getmaxpos) ();
   void (*doubles) (int val);
   void (*fullscreen) ();
   int (*height) ();
   int (*width) ();
   int (*frame) ();
   float (*fps) ();
     guint32 (*open) (char *name);
   void (*close) ();
   void (*lexit) ();
   char *(*getset) (char *key);
   void (*setset) (char *key, char *val);
   void (*wrtcfg) ();
   void (*setass) (char *type, char *plug);
   char **(*getplugset) ();
   void (*actplugset) ();
   char *(*geterr) ();
   int (*isplay) ();
} loader_funcs;

void
player_assign_funcs (loader_funcs f)
{
   loader_close = f.close;
   loader_get_setting = f.getset;
   loader_set_setting = f.setset;
   loader_activate_settings = f.actplugset;
   loader_pause = f.pause;
   loader_play = f.play;
   loader_stop = f.stop;
   loader_is_playing = f.isplay;
   loader_seek = f.seek;
}
