#include "wm_player.h"
#include <avifile/renderer.h>

gchar **
player_get_fnmasks ()
{
   static gchar *retval[5];

   retval[0] = g_strdup ("*.[aA][vV][iI]");
   retval[1] = g_strdup ("file:*.[aA][vV][iI]");
   retval[2] = g_strdup ("*.[aA][sS][fF]");
   retval[3] = g_strdup ("file:*.[aA][sS][fF]");
   retval[4] = NULL;
   return retval;
}

char **
player_get_settings ()
{
   static char *retval[6];

   retval[0] =
      strdup ("string\twm_av_sync_adjust\tAV Sync Adjustment Factor");
   retval[1] =
      strdup ("bool\twm_scale_to_fs\tScale instead of VidMode in fullscreen");
   retval[2] = strdup("bool\twm_use_yuv\tUse XVideo Extension for Hardware scaling");
   retval[3] = strdup("bool\twm_enforce_aspect\tEnforce Aspect ratio of Video");
   retval[4] = NULL;
   return retval;
}

void
check_fs_settings ()
{
	if (loader_get_setting("wm_enforce_aspect") && !strcmp("true",loader_get_setting("wm_enforce_aspect")))
		n->player->Set(IAviPlayer::VIDEO_PRESERVE_ASPECT,true,0);
	else
		n->player->Set(IAviPlayer::VIDEO_PRESERVE_ASPECT,false,0);
	if (loader_get_setting ("wm_use_yuv") && 
		!strcmp("true",loader_get_setting("wm_use_yuv")))
		n->player->Set(IAviPlayer::USE_YUV,true,0);
	else
		n->player->Set(IAviPlayer::USE_YUV,false,0);
   if (loader_get_setting ("wm_scale_to_fs") &&
       !strcmp ("true", loader_get_setting ("wm_scale_to_fs")))
      n->fullscreen_scale = true;
   else
      n->fullscreen_scale = false;
}

void
check_sync_adjust ()
{
   char *temp;

   if ((temp = loader_get_setting ("wm_sync_adjust"))) {
      float adj;

      sscanf (temp, "%f", &adj);
      n->player->SetAsync (adj);
   }
}

void
player_activate_settings ()
{
   check_sync_adjust ();
	check_fs_settings();
   const vector<VideoRenderer*>& vrend = n->player->GetVideoRenderers();
   if (vrend.size() > 0) {
	   vrend[0]->SetCaption(n->name,NULL);
   }
}
