/* AVI/ASF plugin for Xtheater, using aviplay library 

   Copyright (C) 2000 Jarrod Johnson

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   Author may be contacted at jbjohns4@eos.ncsu.edu
*/

#include <stdint.h>
#include "wm_player.h"

void
player_seek (float pos)
{
   if (!n->file_opened)
      return;
   n->player->Reseek (pos);
}

void
player_set_volume(float vol)
{
	int vol2 = int(vol);
	n->player->Set(IAviPlayer::AUDIO_VOLUME,vol2,0);
}

float player_get_volume()
{
	int retval;
	n->player->Get(IAviPlayer::AUDIO_VOLUME,&retval,0);
	return float(retval);
}

float player_get_max_volume()
{
	return 1000.0;
}

void
player_rw ()
{
   if (!n->file_opened)
      return;
   if (n->player->IsPlaying ())
      loader_seek (0);
}

void
player_play ()
{
   if (!n->file_opened)
      return;
   if (!n->player->IsPlaying ())
      n->player->Start ();
   else
      n->player->Pause (0);
   n->is_playing = 1;
}

void
player_pause ()
{
   if (!n->file_opened)
      return;
   n->is_playing = 0;
   n->player->Pause (1);
}

void
player_stop ()
{
   if (!n->file_opened)
      return;
   n->is_playing = 0;
   loader_seek (0);
   n->player->Pause (1);
//   SDL_FillRect (n->screen, NULL, SDL_MapRGB (n->screen->format, 0, 0, 0));
//   SDL_UpdateRect (n->screen, 0, 0, 0, 0);
}

float
player_get_max_position ()
{
   if (n->file_opened)
      return n->player->GetVideoLengthTime ();
   return 0.0;
}


void
player_close ()
{
   if (n->player)
      delete n->player;

   n->player = 0;
   //Don't do this ourselves anymore (for the time being SDL_Quit();
}

int
player_is_playing ()
{
   return n->file_opened && n->is_playing;
}

float
player_get_fps ()
{
   //AVIfile does not report acheived frame rate, simply reports 
   //what movie was recorded at.  No need to hammer external libraries
   //more than needed, so the result is returned from what is read at 
   //initialization time.
   if (n->file_opened)
      return n->player->GetFps(); //fps;
   return 0.0;
}

int
player_get_width ()
{
   if (n->file_opened)
      return n->player->GetWidth ();
   return 0;
}

int
player_get_height ()
{
   if (n->file_opened)
      return n->player->GetHeight ();
   return 0;
}

int
player_get_time ()
{
	if (n->file_opened)
		return (int)n->player->GetPos();
	return 0;
}

int player_get_max_time()
{
	if (n->file_opened)
		return (int)n->player->GetLengthTime();
	return 0;
}

float
player_get_position ()
{
   if (n->file_opened)
      return n->player->GetPos ();
   return 0.0;
}
