
/* GTK UI code for Xtheater - File dialog

   Copyright (C) 2000 Jarrod Johnson

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   Author may be contacted at jbjohns4@eos.ncsu.edu
*/
#include <string.h>
#include "gtk-ui.h"
void file_select (GtkWidget * w, ui_data * m)
{
   if (!m->file_sel) {
      m->file_sel = gtk_file_selection_new ("Open File:");
      gtk_signal_connect (GTK_OBJECT
                          (GTK_FILE_SELECTION (m->file_sel)->ok_button),
                          "clicked", GTK_SIGNAL_FUNC (file_ok), m);
      gtk_signal_connect (GTK_OBJECT
                          (GTK_FILE_SELECTION (m->file_sel)->cancel_button),
                          "clicked", GTK_SIGNAL_FUNC (file_cancel), m);
   }
   gtk_widget_show (m->file_sel);
}

void file_ok (GtkWidget * w, ui_data * m)
{
   gtk_widget_hide (m->file_sel);
   ui_close (0, m);
   strncpy (m->name,
            gtk_file_selection_get_filename (GTK_FILE_SELECTION
                                             (m->file_sel)), PATH_MAX);
   ui_open (m);
}

void file_cancel (GtkWidget * w, ui_data * m)
{
   gtk_widget_hide (m->file_sel);
}
