
/* GTK UI code for Xtheater - Functions thast handle putting xpm on widgets

   Copyright (C) 2000 Jarrod Johnson

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   Author may be contacted at jbjohns4@eos.ncsu.edu
*/

#include "gtk-ui.h"

/*#include "buttons.h"*/
#include "../icon.h"

void ui_do_icon (ui_data * m)
{
   static GdkPixmap *icon_pix;
   static GdkBitmap *icon_mask;
   GtkStyle *style;

   style = gtk_widget_get_style (m->window);
   icon_pix = gdk_pixmap_create_from_xpm_d (m->window->window, &icon_mask,
                                            &style->bg[GTK_STATE_NORMAL],
                                            xtheater_icon);
   gdk_window_set_icon (m->window->window, NULL, icon_pix, icon_mask);
}

void ui_button_pixmap (ui_data * m, GtkWidget * button, gchar ** the_xpm)
{
   GdkPixmap *pixmap;
   GdkColormap *map;
   GdkBitmap *mask;
   GtkWidget *pixmapwid;

   map = gtk_widget_get_colormap (m->window);
   pixmap = gdk_pixmap_colormap_create_from_xpm_d (m->window->window, map,
                                                   &mask, NULL, the_xpm);
   pixmapwid = gtk_pixmap_new (pixmap, mask);
   gtk_container_add (GTK_CONTAINER (button), pixmapwid);
   gtk_widget_show (pixmapwid);
   gdk_pixmap_unref (pixmap);
}
