
/* GTK UI code for Xtheater - Code that handles opening of media

   Copyright (C) 2000 Jarrod Johnson

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   Author may be contacted at jbjohns4@eos.ncsu.edu
*/

/* Functions to handle Opening media */
#include <stdio.h>
#include <string.h>
#include "gtk-ui.h"
int ui_dialog (char *mess);
void open_vcd (GtkWidget * w, ui_data * m)
{
   ui_close (0, m);
   strcpy (m->name, "VCD");
   ui_open (m);
}

int ui_open (ui_data * m)
{
   char temp[PATH_MAX];
   char *cur;

   m->user_seeking = 0;
   m->updating = 0;
#ifdef DEBUG
   fprintf (stderr, "getting ready to open\n");
#endif
   m->features = loader_open (m->name);
#ifdef DEBUG
   fprintf (stderr, "opened\n");
#endif
   if (!(m->features)) {
      char *mess;

      mess = (char *) malloc (PATH_MAX + 30);
      sprintf (mess, "Open of %s failed, error was: %s", m->name,
               loader_get_error ());
      return ui_dialog (mess);
   }
   cur = (rindex (m->name, '/') ? rindex (m->name, '/') + 1 : m->name);
   gtk_label_set_text (GTK_LABEL (m->name_label), cur);
   GTK_ADJUSTMENT (m->seek_position)->upper = loader_get_max_position ();
   GTK_ADJUSTMENT (m->volume_position)->upper = loader_get_max_volume ();
   sprintf (temp, "Res: %d x %d", loader_get_width (), loader_get_height ());
   gtk_label_set_text (GTK_LABEL (m->res_label), temp);
   gtk_adjustment_set_value (GTK_ADJUSTMENT (m->volume_position),
                             loader_get_volume ());
   ui_reconfig (m);
   ui_play (m->play_button, m);
   ui_loop (m->loop_toggle, m);
   ui_double (m->double_toggle);
   ui_fullscreen (m->full_toggle);
   return 0;
}
