#include <stdio.h>

/* GTK UI code for Xtheater - Functions to control Playback

   Copyright (C) 2000 Jarrod Johnson

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   Author may be contacted at jbjohns4@eos.ncsu.edu
*/

/* Functions for general playback control */
#include "gtk-ui.h"
void ui_pause (GtkWidget * w, ui_data * m)
{
   m->play_expected = 0;
   loader_pause ();
   screensaver_restore (GDK_DISPLAY ());
   gtk_widget_hide (w);
   if (m->features & CAN_PLAY)
      gtk_widget_show (m->play_button);
}

void ui_play (GtkWidget * w, ui_data * m)
{
   screensaver_disable (GDK_DISPLAY ());
   loader_play ();
   m->play_expected = 1;
   if (w)
      gtk_widget_hide (w);
   if (m->features & CAN_PAUSE)
      gtk_widget_show (m->pause_button);
}

void ui_stop (GtkWidget * w, ui_data * m)
{
   m->play_expected = 0;
   loader_stop ();
   screensaver_restore (GDK_DISPLAY ());
   gtk_widget_hide (m->pause_button);
   if (m->features & CAN_PLAY)
      gtk_widget_show (m->play_button);
}

void ui_loop (GtkWidget * w, ui_data * m)
{
   m->looping = GTK_TOGGLE_BUTTON (w)->active;
}

void ui_seek (GtkObject * w, ui_data * m)
{
	if (m->features & GIVES_TIME) {
		char* tmp;
		int currtime;
		currtime = GTK_ADJUSTMENT(w)->value/GTK_ADJUSTMENT(w)->upper * loader_get_max_time();
		if (loader_get_max_time() > 3600) 
			tmp = g_strdup_printf("Seek: %.2d:%.2d:%.2d/%.2d:%.2d:%.2d",
					currtime/3600,
					currtime%3600/60,
					currtime%60,
					loader_get_max_time()/3600,
					loader_get_max_time()%3600/60,
					loader_get_max_time()%60);
		else
			tmp = g_strdup_printf("Seek: %.2d:%.2d/%.2d:%.2d",
					currtime/60,
					currtime%60,
					loader_get_max_time()/60,
					loader_get_max_time()%60);
   	gtk_label_set_text (GTK_LABEL (m->seek_label), tmp);
	} else {
   	gtk_label_set_text (GTK_LABEL (m->seek_label), "Seek:");
	}
   /*if (!m->updating)
      loader_seek (GTK_ADJUSTMENT (w)->value);
	*/
}

void ui_double (GtkWidget * w)
{
   if (GTK_TOGGLE_BUTTON (w)->active)
      loader_double (TRUE);
   else
      loader_double (FALSE);
}

void ui_fullscreen (GtkWidget * w)
{
   if (GTK_TOGGLE_BUTTON (w)->active) {
      loader_fullscreen ();
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (w), FALSE);
   }
}

void ui_rw (GtkWidget * w)
{
   loader_rw ();
}

void ui_ff (GtkWidget * w)
{
   loader_ff ();
}
