#include <stdio.h>

/* GTK UI code for Xtheater - Dynamic reconfiguration code

   Copyright (C) 2000 Jarrod Johnson

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   Author may be contacted at jbjohns4@eos.ncsu.edu
*/

#include <string.h>
#include "gtk-ui.h"

void ui_reconfig (ui_data * m)
{
   ui_widget_set_visible (m->seek_label, m->features & CAN_SEEK);
   ui_widget_set_visible (m->seek_scale, m->features & CAN_SEEK);
   ui_widget_set_visible (m->volume_label, m->features & CAN_VOLUME);
   ui_widget_set_visible (m->volume_scale, m->features & CAN_VOLUME);
   ui_widget_set_visible (m->play_button, (m->features & CAN_PLAY)
                          && !loader_is_playing ());
   ui_widget_set_visible (m->pause_button, (m->features & CAN_PAUSE)
                          && loader_is_playing ());
   ui_widget_set_visible (m->stop_button, m->features & CAN_STOP);
   ui_widget_set_visible (m->ff_button, m->features & CAN_FF);
   ui_widget_set_visible (m->rw_button, m->features & CAN_RW);
   ui_widget_set_visible (m->prev_button, m->features & CAN_PREV);
   ui_widget_set_visible (m->next_button, m->features & CAN_NEXT);
   ui_widget_set_visible (m->mute_toggle, m->features & CAN_VOLUME);
   ui_widget_set_visible (m->double_toggle, m->features & CAN_DOUBLE);
   ui_widget_set_visible (m->full_toggle, m->features & CAN_FULLSCREEN);
   ui_widget_set_visible (m->res_label, m->features & GIVES_RES);
   ui_widget_set_visible (m->fps_label, m->features & GIVES_FPS);
   ui_widget_set_visible (m->frame_label, m->features & GIVES_FRAME);
   if (loader_get_setting ("gtk_ui_double"))
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (m->double_toggle),
                                    !strcmp (loader_get_setting
                                             ("gtk_ui_double"), "true"));
   if (loader_get_setting ("gtk_ui_loop"))
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (m->loop_toggle),
                                    !strcmp (loader_get_setting
                                             ("gtk_ui_loop"), "true"));
}
