#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "screensaver.h"

#ifdef HAVE_DPMS
#include <X11/extensions/dpms.h>

//static BOOL dpms_was_enabled;
static int dpms_was_enabled;
#endif

enum {
   DEFAULT,
   DISABLED
} saver_state = DEFAULT;
static int timeout;

#define OFF (0)

static int set_screensaver (Display * dpy, int newtime);

void screensaver_disable (Display * dpy)
{
   if (saver_state == DISABLED)
      return;
   saver_state = DISABLED;

   /*
      disable screensaver 
    */
   timeout = set_screensaver (dpy, OFF);

#ifdef HAVE_DPMS
   {
      int dummy;

      if (DPMSQueryExtension (dpy, &dummy, &dummy) && DPMSCapable (dpy)) {
         //CARD16 dummy2;
         unsigned short dummy2;

         DPMSInfo (dpy, &dummy2, &dpms_was_enabled);
         if (dpms_was_enabled)
            DPMSDisable (dpy);
      } else
         dpms_was_enabled = 0;
   }
#endif
}

void screensaver_restore (Display * dpy)
{
   if (saver_state == DEFAULT)
      return;
   saver_state = DEFAULT;

   /*
      restore old state 
    */
   set_screensaver (dpy, timeout);
#ifdef HAVE_DPMS
   if (dpms_was_enabled)
      DPMSEnable (dpy);
#endif
}

int set_screensaver (Display * dpy, int newtime)
{
   int oldtime, interval, blank, expose;

   XGetScreenSaver (dpy, &oldtime, &interval, &blank, &expose);
   XSetScreenSaver (dpy, newtime, interval, blank, expose);
   return oldtime;
}
