
/* GTK UI code for Xtheater - Handles Connectting widgets to functions.

   Copyright (C) 2000 Jarrod Johnson

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   Author may be contacted at jbjohns4@eos.ncsu.edu
*/

/* Connect widgets to callback functions */
#include "gtk-ui.h"
static GtkTargetEntry drop_types[] = {
   {"text/plain", 0, 0},
   {"text/uri-list", 0, 1},
   {"STRING", 0, 3}
};

void ui_connect_signals (ui_data * md)
{
   ui_data *m = (ui_data *) md;

   gtk_signal_connect (GTK_OBJECT (m->open_button), "clicked",
                       GTK_SIGNAL_FUNC (file_select), m);
   gtk_signal_connect (GTK_OBJECT (m->pause_button), "clicked",
                       GTK_SIGNAL_FUNC (ui_pause), m);
   gtk_signal_connect (GTK_OBJECT (m->play_button), "clicked",
                       GTK_SIGNAL_FUNC (ui_play), m);
   gtk_signal_connect (GTK_OBJECT (m->stop_button), "clicked",
                       GTK_SIGNAL_FUNC (ui_stop), m);
   gtk_signal_connect (GTK_OBJECT (m->mute_toggle), "clicked",
                       GTK_SIGNAL_FUNC (ui_mute), m);

   gtk_signal_connect_object (GTK_OBJECT (m->double_toggle), "clicked",
                              GTK_SIGNAL_FUNC (ui_double),
                              (gpointer) m->double_toggle);
   gtk_signal_connect (GTK_OBJECT (m->loop_toggle), "clicked",
                       GTK_SIGNAL_FUNC (ui_loop), m);
   gtk_signal_connect_object (GTK_OBJECT (m->full_toggle), "clicked",
                              GTK_SIGNAL_FUNC (ui_fullscreen),
                              (gpointer) m->full_toggle);
   gtk_signal_connect_object (GTK_OBJECT (m->rw_button), "clicked",
                              GTK_SIGNAL_FUNC (ui_rw), 0);
   gtk_signal_connect_object (GTK_OBJECT (m->ff_button), "clicked",
                              GTK_SIGNAL_FUNC (ui_ff), 0);

   gtk_signal_connect (GTK_OBJECT (m->seek_position), "value_changed",
                       GTK_SIGNAL_FUNC (ui_seek), m);
   gtk_signal_connect (GTK_OBJECT (m->seek_scale), "button_press_event",
                       GTK_SIGNAL_FUNC (ui_stop_track), m);
   gtk_signal_connect (GTK_OBJECT (m->seek_scale), "button_release_event",
                       GTK_SIGNAL_FUNC (ui_start_track), m);
   gtk_signal_connect (GTK_OBJECT (m->volume_position), "value_changed",
                       GTK_SIGNAL_FUNC (ui_set_volume), m);

   gtk_signal_connect (GTK_OBJECT (m->media_open), "activate",
                       GTK_SIGNAL_FUNC (file_select), m);
   gtk_signal_connect (GTK_OBJECT (m->media_open_vcd), "activate",
                       GTK_SIGNAL_FUNC (open_vcd), m);
   gtk_signal_connect (GTK_OBJECT (m->media_open_url), "activate",
                       GTK_SIGNAL_FUNC (open_url), m);
   gtk_signal_connect (GTK_OBJECT (m->media_close), "activate",
                       GTK_SIGNAL_FUNC (ui_close), m);
   gtk_signal_connect_object (GTK_OBJECT (m->media_quit), "activate",
                              GTK_SIGNAL_FUNC (ui_exit), 0);
   gtk_signal_connect_object (GTK_OBJECT (m->option_save), "activate",
                              GTK_SIGNAL_FUNC (ui_write_config), 0);
   gtk_signal_connect (GTK_OBJECT (m->option_ui), "activate",
                       GTK_SIGNAL_FUNC (ui_options), m);
   gtk_signal_connect (GTK_OBJECT (m->option_plugin), "activate",
                       GTK_SIGNAL_FUNC (ui_plugin_options), m);
   gtk_signal_connect_object (GTK_OBJECT (m->window), "delete_event",
                              GTK_SIGNAL_FUNC (ui_exit), 0);
   gtk_signal_connect_object (GTK_OBJECT (m->info_about), "activate",
                              GTK_SIGNAL_FUNC (ui_about), 0);
   gtk_drag_dest_set (m->window,
                      GTK_DEST_DEFAULT_DROP | GTK_DEST_DEFAULT_MOTION,
                      drop_types, 3, GDK_ACTION_COPY | GDK_ACTION_MOVE);
   gtk_signal_connect (GTK_OBJECT (m->window), "drag_data_received",
                       GTK_SIGNAL_FUNC (ui_drop_received), m);
}
