
/* GTK UI code for Xtheater - UI options dialog

   Copyright (C) 2000 Jarrod Johnson

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   Author may be contacted at jbjohns4@eos.ncsu.edu
*/

/* Routines related to options setting and retrieval */
#include "gtk-ui.h"
#include <string.h>
#include <stdio.h>
#include <stdlib.h>

/* Locally used widgets */
GtkWidget *option_window;
GtkWidget *xres;
GtkWidget *yres;
GtkWidget *dbl;
GtkWidget *loop;

/* Local functions*/
void ui_commit_opts (GtkWidget * w, ui_data * m);
void ui_set_mainwinsize (ui_data * m);
void apply_settings (GtkWidget * i, gpointer ig);
void apply_savesettings (GtkWidget * b, gpointer ig);

/* Data */
static GtkWidget *labs[64];
static GtkWidget *sets[64];
static char type[64];
static char plug_opts[64][80];
static int num_settings;

gint enact_set (GtkWidget * w, char *c)
{
   if (GTK_TOGGLE_BUTTON (w)->active)
      loader_set_setting (c, "true");
   else
      loader_set_setting (c, "false");
   loader_activate_settings ();
}

void ui_plugin_options (GtkWidget * w, ui_data * m)
{
   static GtkWidget *plug_opt;
   char *tmp;
   char **opts;
   GtkWidget *vertbox;
   GtkWidget *horbox[64];
   GtkWidget *apply;
   GtkWidget *close;
   GtkWidget *applysave;
   int i;

   opts = loader_get_plugin_settings ();
   if (!opts) {
      ui_dialog
         ("No player loaded or current player does not support settings");
      return;
   }
   plug_opt = gtk_window_new (GTK_WINDOW_DIALOG);
   vertbox = gtk_vbox_new (0, 0);
   gtk_container_add (GTK_CONTAINER (plug_opt), vertbox);
   i = -1;
   while (opts[++i]) {
      horbox[i] = gtk_hbox_new (0, 0);
      if (!strncmp (opts[i], "string", 6)) {
         type[i] = 's';
         tmp = opts[i] + 7;
         while (*(tmp++) != '\t');
         sets[i] = gtk_entry_new ();
         labs[i] = gtk_label_new (tmp);
         strncpy (plug_opts[i], opts[i] + 7, tmp - opts[i] - 8);
         gtk_box_pack_start (GTK_BOX (horbox[i]), sets[i], 0, 0, 0);
         gtk_box_pack_start (GTK_BOX (horbox[i]), labs[i], 0, 0, 0);
         if (loader_get_setting (plug_opts[i]))
            gtk_entry_set_text (GTK_ENTRY (sets[i]),
                                loader_get_setting (plug_opts[i]));
      }
      if (!strncmp (opts[i], "bool", 4)) {
         type[i] = 'b';
         tmp = opts[i] + 5;
         while (*(tmp++) != '\t');
         sets[i] = gtk_check_button_new ();
         labs[i] = gtk_label_new (tmp);
         strncpy (plug_opts[i], opts[i] + 5, tmp - opts[i] - 6);
         gtk_box_pack_start (GTK_BOX (horbox[i]), sets[i], 0, 0, 0);
         gtk_box_pack_start (GTK_BOX (horbox[i]), labs[i], 0, 0, 0);
         if (loader_get_setting (plug_opts[i]))
            gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (sets[i]),
                                          !strcmp (loader_get_setting
                                                   (plug_opts[i]), "true"));

      }
      gtk_box_pack_start (GTK_BOX (vertbox), horbox[i], 0, 0, 0);
   }
   num_settings = i;
   horbox[i] = gtk_hbox_new (0, 3);
   apply = gtk_button_new_with_label ("Apply");
   applysave = gtk_button_new_with_label ("Apply and Save");
   close = gtk_button_new_with_label ("Close");
   gtk_box_pack_start (GTK_BOX (vertbox), horbox[i], 0, 0, 0);
   gtk_box_pack_start (GTK_BOX (horbox[i]), apply, 0, 0, 0);
   gtk_box_pack_start (GTK_BOX (horbox[i]), applysave, 0, 0, 0);
   gtk_box_pack_start (GTK_BOX (horbox[i]), close, 0, 0, 0);
   gtk_signal_connect (GTK_OBJECT (apply), "clicked",
                       GTK_SIGNAL_FUNC (apply_settings), NULL);
   gtk_signal_connect (GTK_OBJECT (applysave), "clicked",
                       GTK_SIGNAL_FUNC (apply_savesettings), NULL);
   gtk_signal_connect_object (GTK_OBJECT (close), "clicked",
                              GTK_SIGNAL_FUNC (gtk_widget_destroy),
                              GTK_OBJECT (plug_opt));
   gtk_signal_connect_object (GTK_OBJECT (plug_opt), "delete_event",
                              GTK_SIGNAL_FUNC (gtk_widget_destroy),
                              GTK_OBJECT (plug_opt));

   gtk_widget_show_all (vertbox);
   gtk_widget_show (plug_opt);
}

void apply_savesettings (GtkWidget * b, gpointer ig)
{
   apply_settings (b, ig);
   loader_write_config ();
}

void apply_settings (GtkWidget * b, gpointer ig)
{
   int i;

   for (i = 0; i < num_settings; i++) {
      switch (type[i]) {
         case 'b':
            if (GTK_TOGGLE_BUTTON (sets[i])->active)
               loader_set_setting (plug_opts[i], "true");
            else
               loader_set_setting (plug_opts[i], "false");
            break;
         case 's':
            loader_set_setting (plug_opts[i],
                                gtk_entry_get_text (GTK_ENTRY (sets[i])));
            break;
      }
   }
   loader_activate_settings ();
}

void ui_options (GtkWidget * w, ui_data * m)
{
   GtkWidget *ok_button;
   GtkWidget *xreslab;
   GtkWidget *yreslab;
   char tmp[9];

   if (option_window)
      return;
   option_window = gtk_dialog_new ();
   xreslab = gtk_label_new ("Width of control window:");
   yreslab = gtk_label_new ("Height of contol window:");
   xres = gtk_entry_new ();
   yres = gtk_entry_new ();
   dbl = gtk_check_button_new_with_label ("Doublesize by default");
   loop = gtk_check_button_new_with_label ("Loop by default");
   if (loader_get_setting ("gtk_ui_double"))
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (dbl),
                                    !strcmp (loader_get_setting
                                             ("gtk_ui_double"), "true"));
   if (loader_get_setting ("gtk_ui_loop"))
      gtk_toggle_button_set_active (GTK_TOGGLE_BUTTON (loop),
                                    !strcmp (loader_get_setting
                                             ("gtk_ui_loop"), "true"));

   sprintf (tmp, "%d", m->ui_width);
   gtk_entry_set_text (GTK_ENTRY (xres), tmp);
   sprintf (tmp, "%d", m->ui_height);
   gtk_entry_set_text (GTK_ENTRY (yres), tmp);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (option_window)->vbox), xreslab,
                       TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (option_window)->vbox), xres, TRUE,
                       TRUE, 0);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (option_window)->vbox), yreslab,
                       TRUE, TRUE, 0);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (option_window)->vbox), yres, TRUE,
                       TRUE, 0);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (option_window)->vbox), dbl, TRUE,
                       TRUE, 0);
   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (option_window)->vbox), loop, TRUE,
                       TRUE, 0);

   ok_button = gtk_button_new_with_label ("Ok");

   gtk_box_pack_start (GTK_BOX (GTK_DIALOG (option_window)->action_area),
                       ok_button, TRUE, FALSE, 10);
   gtk_signal_connect (GTK_OBJECT (ok_button), "clicked",
                       GTK_SIGNAL_FUNC (ui_commit_opts), m);
   gtk_widget_show_all (option_window);
}

void ui_commit_opts (GtkWidget * w, ui_data * m)
{
   loader_set_setting ("gtk_ui_width", gtk_entry_get_text (GTK_ENTRY (xres)));
   loader_set_setting ("gtk_ui_height", gtk_entry_get_text (GTK_ENTRY (yres)));
   loader_set_setting ("gtk_ui_double",
                       (GTK_TOGGLE_BUTTON (dbl)->active ? "true" : "false"));
   loader_set_setting ("gtk_ui_loop",
                       (GTK_TOGGLE_BUTTON (loop)->active ? "true" : "false"));

   ui_set_mainwinsize (m);
   ui_reconfig (m);
   gtk_widget_set_usize (GTK_WIDGET (m->window), m->ui_width, m->ui_height);
   gtk_widget_destroy (option_window);
   option_window = 0;
}

void ui_write_config (GtkWidget * j)
{
   loader_write_config ();
}

void ui_set_mainwinsize (ui_data * m)
{
   char *x;

   if ((x = loader_get_setting ("gtk_ui_width")))
      m->ui_width = atoi (x);
   if ((x = loader_get_setting ("gtk_ui_height")))
      m->ui_height = atoi (x);
}
