
/* GTK UI code for Xtheater - widget generation code

   Copyright (C) 2000 Jarrod Johnson

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.

   Author may be contacted at jbjohns4@eos.ncsu.edu
*/
#include "gtk-ui.h"
#include "buttons.h"
void ui_set_mainwinsize ();

/* Function to generate the widgets in an abstract sense */
void ui_create_widgets (ui_data * m)
{
   m->window = gtk_window_new (GTK_WINDOW_TOPLEVEL);
   gtk_window_set_title (GTK_WINDOW (m->window), "Xtheater");
   ui_set_mainwinsize (m);
   gtk_widget_set_usize (GTK_WIDGET (m->window), m->ui_width, m->ui_height);
   m->main_column = gtk_vbox_new (FALSE, 1);
   ui_menu_create (m);
   m->info_row = gtk_hbox_new (FALSE, 1);

   m->button_row = gtk_hbox_new (FALSE, 1);
   m->toggle_row = gtk_hbox_new (FALSE, 1);

   m->play_button = gtk_button_new ();
   m->pause_button = gtk_button_new ();
   m->stop_button = gtk_button_new ();
   m->ff_button = gtk_button_new ();
   m->rw_button = gtk_button_new ();
   m->prev_button = gtk_button_new ();
   m->next_button = gtk_button_new ();
   m->open_button = gtk_button_new ();
   ui_button_pixmap (m, m->pause_button, (gchar **) pause_xpm);
   ui_button_pixmap (m, m->play_button, (gchar **) play_xpm);
   ui_button_pixmap (m, m->stop_button, (gchar **) stop_xpm);
   ui_button_pixmap (m, m->ff_button, (gchar **) ff_xpm);
   ui_button_pixmap (m, m->rw_button, (gchar **) rw_xpm);
   ui_button_pixmap (m, m->next_button, (gchar **) next_xpm);
   ui_button_pixmap (m, m->prev_button, (gchar **) prev_xpm);
   ui_button_pixmap (m, m->open_button, (gchar **) open_xpm);

   m->loop_toggle = gtk_toggle_button_new_with_label ("Loop");
   m->mute_toggle = gtk_toggle_button_new_with_label ("Mute");
   m->double_toggle = gtk_toggle_button_new_with_label ("Doublesize");
   m->full_toggle = gtk_toggle_button_new_with_label ("Fullscreen");

   m->name_label = gtk_label_new ("No Media Open");
   m->res_label = gtk_label_new ("Res: ??? x ???");
   m->fps_label = gtk_label_new ("FPS: ??.??");
   m->frame_label = gtk_label_new ("Frame: ???");
   m->volume_label = gtk_label_new ("Volume:");
   m->seek_label = gtk_label_new ("Seek:");

   m->seek_position = gtk_adjustment_new (0, 0, 0, 1, 5, 1);
   m->volume_position = gtk_adjustment_new (0, 0, 100, 1, 5, 1);
   m->seek_scale = gtk_hscale_new (GTK_ADJUSTMENT (m->seek_position));
   m->volume_scale = gtk_hscale_new (GTK_ADJUSTMENT (m->volume_position));
   gtk_scale_set_draw_value (GTK_SCALE (m->seek_scale), 0);
   gtk_scale_set_draw_value (GTK_SCALE (m->volume_scale), 0);
   gtk_range_set_update_policy (GTK_RANGE (m->seek_scale),
                                GTK_UPDATE_CONTINUOUS);
   gtk_range_set_update_policy (GTK_RANGE (m->volume_scale),
                                GTK_UPDATE_CONTINUOUS);

}
