
/* Header specification for Xtheater ui plugins */
#ifndef __XTHEATER_UI_H
#define __XTHEATER_UI_H
#include <gmodule.h>
G_MODULE_EXPORT int ui_init (int *argc, char **argv[]);
G_MODULE_EXPORT int ui_activate ();
G_MODULE_EXPORT int ui_deactivate ();
G_MODULE_EXPORT int ui_close_media ();
G_MODULE_EXPORT int ui_shutdown ();

int (*loader_is_playing) ();
int (*loader_is_atend) ();
void (*loader_play) ();
void (*loader_pause) ();
void (*loader_stop) ();
void (*loader_ff) ();
void (*loader_rw) ();
void (*loader_prev) ();
void (*loader_next) ();
void (*loader_loop) ();
void (*loader_set_volume) (float vol);
float (*loader_get_volume) ();
float (*loader_get_max_volume) ();
void (*loader_seek) (float position);
int (*loader_get_time) ();
int (*loader_get_max_time) ();
float (*loader_get_position) ();
float (*loader_get_max_position) ();
void (*loader_double) (int val);
void (*loader_fullscreen) ();

guint32 (*loader_open) (char *name);
int (*loader_get_height) ();
int (*loader_get_width) ();
int (*loader_get_frame) ();
float (*loader_get_fps) ();
void (*loader_close) ();
void (*loader_exit) ();
void (*loader_write_config) ();
void (*loader_set_setting) (char *key, char *val);
char *(*loader_get_setting) ();
void (*loader_set_assoc) (char *type, char *plug);
char **(*loader_get_plugin_settings) ();
void (*loader_activate_settings) ();
char *(*loader_get_error) ();
#endif
