
/*
 * pseudo.c
 *
 * (C) Copyright 1995 Archie L. Cobbs
 */

#include <stdio.h>
#include <stdlib.h>
#include "util.h"
#include "error.h"
#include "names.h"
#include "asm.h"

/*
 * PsAscii()
 *
 * .ascii .asciz .dci
 */

void
PsAscii(TValue tval, int zterm, int dci)
{
	int		k;

/* Output string bytes */

	for (k = 0; k < tval->len; k++)
		if (dci && k == tval->len - 1)
			Emit(tval->chars[k] ^ 0x80);
		else
			Emit(tval->chars[k]);

/* Add trailing zero if needed */

	if (zterm)
		Emit(0);
}

/*
 * PsData()
 */

void
PsData(List list, int numBytes, int bigEndian)
{
	int		bytes;

/* Compute byte mask */

	for (bytes = 0; numBytes; numBytes--)
		bytes = (bytes << 1) | 1;

/* Emit list */

	for ( ; list; list = list->next)
		EmitIvalue(&list->u.ivalue, bigEndian, bytes);
}

