
/*
 * link.h
 *
 * (C) Copyright 1995 Archie L. Cobbs
 *
 */

/*
 * DEFINITIONS
 */

/* Helpful macro */

	#define	RoundUp(x,n)		(((x) + (n-1)) & ~(n-1))

/* Compile-time options */

	#define	DEFAULT_OUTFILE		"a.out"		/* Default output file */
	#define	MAX_SYMBOL_CHARS	65536		/* Max total symbol name chars */
	#define	MAX_EXPORT_SYMS		8192		/* Max exported symbols */
	#define	MAX_RELOCATIONS		8192		/* Max relocation entries */

/* Symbols */

	OpaqueDecl(Symbol);
	OpaqueDefn(Symbol)
	{
		unsigned			id;			/* Name */
		char				*filename;	/* Which file it came from */
		short				segment;	/* Segment where symbol lives */
		unsigned			offset;		/* Offset into segment */
		Symbol				next;		/* Next in hash chain (see "hash.c") */
	};

/*
 * VARIABLES
 */

/* Command line args */

	extern	int				gDebug;
	extern	int				gVerbose;

/* Names database */

	extern	Names			gNames;

/* Segment output buffers */

	extern	Byte			*gSegBuffer[];

/* Relocation entries */

	extern	struct ObjReloc	*gRelocs[];

/*
 * FUNCTIONS
 */

/* Symbols */

	extern	Symbol			DefineSym(unsigned id);
	extern	Symbol			GetSym(unsigned id);
	extern	void			SymDump(FILE *fp);
	extern	int				SymWrite(FILE *fp);
	extern	void			ShowSym(FILE *fp, Symbol sym);

/* Object file stuff */

	extern	void			WriteObj(FILE *fp, struct ObjHeader *hdr);


