
/*
 * load.h
 *
 * Definitions for Apple 2 loader
 * (C) Copyright 1995 Archie L. Cobbs
 *
 */

/*
 * DEFINITIONS
 */

/* Compile-time constants */

	#define	DEFAULT_LOAD_BASE	0x0800	/* Default load address */
	#define	MAX_SYMBOL_CHARS	65536	/* Max total symbol name chars */
	#define	MAX_EXPORT_SYMS		8192	/* Max exported symbols */

/* How many bytes on a monitor input line */

	#define	EXEC_CHUNK_SIZE		16

/* Symbols */

	OpaqueDecl(Symbol);
	OpaqueDefn(Symbol)
	{
		unsigned			id;			/* Name */
		short				segment;	/* Segment where symbol lives */
		unsigned			offset;		/* Offset into segment */
		Symbol				next;		/* Next in hash chain (see "hash.c") */
	};

/*
 * VARIABLES
 */

/* Command line args */

	extern	int				gDebug;
	extern	int				gVerbose;

/* Names database */

	extern	Names			gNames;

/* Output buffer */

	extern	Byte			*gBuffer;
	extern	unsigned		gBase[NUM_SEGMENTS];

/*
 * FUNCTIONS
 */

/* Relocator */

	extern	void			DoRelocs(FILE *fp, Byte *base, int num);

/* Symbols */

	extern	Symbol			DefineSym(unsigned id);
	extern	Symbol			GetSym(unsigned id);

/* Report unknown symbols */

	extern	void			Unknown(unsigned name);
	extern	int				NextUnknown(void);


