
/*
 * sym.c
 *
 * (C) Copyright 1995 Archie L. Cobbs
 */

#include <stdio.h>
#include <assert.h>
#include "util.h"
#include "error.h"
#include "hash.h"
#include "names.h"
#include "obj.h"
#include "load.h"

/*
 * Definitions
 */

/* How many buckets? */

	#define	NUM_BITS			10

	#define	NUM_BUCKETS			(1 << NUM_BITS)
	#define	HASH_MASK			(NUM_BUCKETS - 1)

/*
 * INTERNAL VARIABLES
 */

/* Hash buckets point to first symbol in the list */

	static	Symbol			sBuckets[NUM_BUCKETS];

/*
 * INTERNAL FUNCTIONS
 */

	static	Symbol			*Locate(unsigned id);

/*
 * DefineSym()
 */

Symbol
DefineSym(unsigned id)
{
	Symbol	sym, *symp;

/* Error if previously defined (sometimes) */

	if ((sym = *(symp = Locate(id))))
		cerror("symbol \"%s\" multiply defined", Name(gNames, id));

/* Make a new entry in the hash chain */

	*symp = sym = NewOpaque(Symbol);

/* Initialize symbol */

	sym->id = id;

/* Done */

	return(sym);
}

/*
 * GetSym()
 *
 * Get symbol table entry
 */

Symbol
GetSym(unsigned id)
{
	return(*Locate(id));
}

/*
 * Locate()
 *
 * Locate (possibly non-existent) entry for given symbol
 */

static	Symbol	*
Locate(unsigned id)
{
	int		bucket;
	Symbol	*symp;

	bucket = Hash(&id, sizeof(id)) & HASH_MASK;
	for (symp = sBuckets + bucket;
			*symp && (*symp)->id != id;
			symp = &(*symp)->next);
	return(symp);
}

