
/*
 * unknown.c
 *
 * (C) Copyright 1995 Archie L. Cobbs
 */

#include <stdio.h>
#include <stdlib.h>
#include <assert.h>
#include "util.h"
#include "error.h"
#include "names.h"
#include "obj.h"
#include "load.h"

/*
 * DEFINITIONS
 */

	#define	MAX_UNKNOWNS	100

/*
 * INTERNAL VARIABLES
 */

	static	int			gNumUnknown = 0;
	static	int			gNextReport = 0;
	static	unsigned	gUnknowns[MAX_UNKNOWNS];

/*
 * Unknown()
 */

void
Unknown(unsigned name)
{
	int		k;

	if (gNumUnknown == MAX_UNKNOWNS)
		cerror("too many unknown symbols");
	for (k = 0; k < gNumUnknown; k++)
		if (gUnknowns[k] == name)
			return;
	gUnknowns[gNumUnknown++] = name;
}

/*
 * NextUnknown()
 */

int
NextUnknown(void)
{
	if (gNextReport == gNumUnknown)
		return(-1);
	return((int) gUnknowns[gNextReport++]);
}

