
/*
 * error.c
 *
 * (C) Copyright 1995 Archie L. Cobbs
 *
 */

#include <stdio.h>
#include <stdarg.h>
#include "util.h"
#include "error.h"

/*
 * DEFINITIONS
 */

	#define	MAX_ERRORS	15

/*
 * INTERNAL VARIABLES
 */

	int			gNumErrors;

/*
 * INTERNAL FUNCTIONS
 */

	static void			where(void);

/*
 *	uerror()
 *
 *	User input caused an error
 *
 */

/* VARARGS1 */

void
uerror(char *fmt, ...)
{
	va_list	args;

	va_start(args, fmt);
	gNumErrors++;
	where();
	vfprintf(stderr, fmt, args);
	fprintf(stderr, "\n");
	if (gNumErrors > MAX_ERRORS)
		cerror("too many errors");
	fflush(stderr);
}

/*
 *	cerror()
 *
 *	Some sort of internal error
 *
 */

volatile	void
cerror(char *fmt, ...)
{
	va_list	args;

	where();
	va_start(args, fmt);
	fprintf(stderr, "internal error: " );
	vfprintf(stderr, fmt, args);
	fprintf(stderr, "\n");
	fflush(stdout);
	va_end(args);
	exit(1);
}

/*
 *	where()
 *
 *	Print current filename and line number
 *
 */

static	void
where(void)
{
	if (gLineNumber >= 1)
		fprintf(stderr, "%s: \"%s\", line %d: ", gProgName,
			gFileName, gLineNumber);
	else
		fprintf(stderr, "%s: \"%s\": ", gProgName, gFileName);
}

