
/*
 * misc.c
 *
 * (C) Copyright 1995 Archie L. Cobbs
 */

#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include "util.h"

/*
 * GetMem()
 */

void	*
GetMem(int len)
{
	void	*m;

	if ((m = calloc(1, len)) == NULL)
		perror("calloc"), Panic("fatal error");
	return(m);
}

/*
 * GetMoreMem()
 */

void	*
GetMoreMem(void *mem, int len)
{
	void	*m;

	if ((m = realloc(mem, len)) == NULL)
		perror("realloc"), Panic("fatal error");
	return(m);
}

/*
 * Usage()
 */

volatile void
Usage(char *msg, ...)
{
	va_list	args;

	if (msg)
	{
		va_start(args, msg);
		fprintf(stderr, "%s: ", gProgName);
		vfprintf(stderr, msg, args);
		fprintf(stderr, "\n");
		va_end(args);
	}
	fprintf(stderr, "Usage: %s %s\n", gProgName, gUsageMsg);
	exit(1);
}

/*
 * Panic()
 */

volatile void
Panic(char *msg, ...)
{
	va_list	args;

	va_start(args, msg);
	fprintf(stderr, "%s: ", gProgName);
	vfprintf(stderr, msg, args);
	fprintf(stderr, "\n");
	va_end(args);
	exit(1);
}

