
/*
 * export.c
 *
 * (C) Copyright 1995 Archie L. Cobbs
 */

#include <stdio.h>
#include <assert.h>
#include "util.h"
#include "error.h"
#include "names.h"
#include "obj.h"
#include "asm.h"

/*
 * INTERNAL VARIABLES
 */

	static	int					gNumExports;
	static	struct ObjSymbol	gExports[MAX_EXPORT_SYMS];

/*
 * Export()
 *
 * Export a local symbol.
 */

void
Export(Symbol sym)
{
	int					k;
	unsigned			nameid;
	struct ObjSymbol	*export;

/* Sanity */

	assert(sym->valid && sym->type == sSegRel);

/* See if already exported */

	for (nameid = NameID(gObjNames, Name(gNames, sym->id)), k = 0;
			k < gNumExports;
			k++)
		if (gExports[k].s_name == nameid)
			return;

/* Add entry */

	if (gNumExports >= MAX_EXPORT_SYMS)
		cerror("out of export entries");

	export = gExports + gNumExports++;

	export->s_name		= nameid;
	export->s_segment	= sym->u.segrel.segment;
	export->s_offset	= sym->u.segrel.offset;
}

/*
 * ExportDump()
 */

unsigned
ExportDump(FILE *fp)
{
	int		k;

	for (k = 0; k < gNumExports; k++)
		if (fwrite(gExports + k, sizeof(*gExports), 1, fp) != 1)
		{
			perror("fwrite");
			cerror("can't write symbol info");
		}

/* Done */

	return(gNumExports);
}

