
/*
 * import.c
 *
 * (C) Copyright 1995 Archie L. Cobbs
 */

#include <stdio.h>
#include <assert.h>
#include "util.h"
#include "error.h"
#include "names.h"
#include "obj.h"
#include "asm.h"

/*
 * INTERNAL VARIABLES
 */

	static	int				gNumZpImports = 0;
	static	unsigned		gZpImports[MAX_IMPORT_SYMS];

/*
 * Import()
 *
 * Import an external symbol. Does nothing.
 */

void
Import(unsigned id)
{
	return;
}

/*
 * ZpImport()
 *
 * Import an external symbol and make it zero-page.
 */

void
ZpImport(unsigned id)
{
	int	k;

/* See if already got it */

	for (k = 0; k < gNumZpImports; k++)
		if (gZpImports[k] == id)
			return;

/* Add entry */

	if (gNumZpImports >= MAX_IMPORT_SYMS)
		cerror("out of ZP import entries");
	gZpImports[gNumZpImports++] = id;
}

/*
 * IsZpImport()
 *
 * Check if external symbol is to be zero page
 */

int
IsZpImport(unsigned id)
{
	int	k;

	for (k = 0; k < gNumZpImports; k++)
		if (gZpImports[k] == id)
			return(TRUE);
	return(FALSE);
}

