
/*
 * obj.h
 *
 * (C) Copyright 1995 Archie L. Cobbs
 *
 */

/*

	OBJECT FILE FORMAT:

		HEADER	- See below
		TEXT	- Text segment
		DATA	- Data segment
		TRELOC	- Relocation entries for text segment
		DRELOC	- Relocation entries for data segment
		SYMTAB	- Table of exported symbols
		SYMBOLS - Symbol string data

	Each of the above sections except the last
	has size equal to a multiple of four bytes.

	RELOCATION INFORMATION:

		o Which segment patch applies to (determined by
		  the table in which the entry lies)
		o Offset into that segment where the patch applies
		o Which bytes to patch, specified using a four bit field
		o Which order to stuff in the value (big or litte endian)
		o An offset to add to the symbol or segment base address
		o Existing values of the affected segment bytes are ignored

*/

/*
 * Segments
 */

	enum
	{
		CodeSegment = 0,
		DataSegment,
		BssSegment,
		AbsSegment,
	};

	#define	NUM_SEGMENTS	4

/*
 * Object file header
 */

/* Change the magic number if the object file format changes */

	#define	OBJ_HEADER_MAGIC	0x6349fa82

	struct	ObjHeader
	{
		unsigned	n_magic;	/* Magic number */
		unsigned	n_text;		/* Size of text segment */
		unsigned	n_data;		/* Size of data segment */
		unsigned	n_bss;		/* Size of bss segment */
		unsigned	n_treloc;	/* Number of text relocation entries */
		unsigned	n_dreloc;	/* Number of data relocation entries */
		unsigned	n_symbols;	/* Number of symbol table entries */
		unsigned	n_strings;	/* Size of strings table */
	};

/*
 * Relocation entry
 */

/* Note that the bitfields may be different on another platform! */

	struct	ObjReloc
	{
		int					r_offset;	/* Add to value before patch */
		unsigned			r_address;	/* Patch address in segment */
		unsigned			r_bigend:1;	/* Set for big endian value */
		unsigned			r_segrel:1;	/* 1 = segment, 0 = symbol */
		unsigned			r_bytes:4;	/* Which bytes to stuff */
		unsigned			r_name:24;	/* Name of segment or symbol */
	};

/*
 * (Exported) symbol information
 */

	struct	ObjSymbol
	{
		Byte				s_segment;	/* What segment symbol lives in */
		unsigned			s_name:24;	/* Offset into string data area */
		unsigned			s_offset;	/* Offset into segment */
	};


