

* This is a comment
	; and these
		; are too

; Let's define some absolute values
; Check out the actual value on the left
; (in the assembler listing output)

COUT		=	$fded
COUT1		=	0xfdf0
_x_y_z		.equ	%10101010
octal666	.equ	0666

; OK, let's compute some expressions

aaa		=	100
bbb		=	3
ccc		=	aaa << bbb
ddd		=	~ ccc
eee		=	! ccc
fff		=	[1+ccc^[aaa/$fefe]!=23]?5:4

; What does right shift do?

minint		=	[1<<31]
ggg		=	minint >> 24

; We can be confusing and use instruction names

asl		=	23
sta		=	999

; Let's make some code: default is CODE section

start:
		lda	sta
		asl	asl
		xor	$FF

; Reference current location

		jmp	*

; Import these symbols

		.import	extern_1
		.import	extern_2, extern_1, extern_2

; Anything undefined is assumed external

		.word	never_heard_of_that_one

; Import but reference addresses as zero page

		.zimport extern_zp

; Make these symbols globally visible

		.export	start, globdat

; Labels can have a colon or not...

label1:
		.global	label1

lable2  	lda     #$20
		bcc     label3
		ADC     $33

; Default .hibit is off

		.byte	'a'
		.hibit	1
		.byte	'a'
		.hibit	0

		lsr

; Note external references

label3		dec	extern_1+4
		dec	extern_zp
		lda	#<extern_1+8
		lda	#>extern_1+8
		ldx	#<COUT
		ldy	#COUT

; OK, let's go to the DATA segment now

		.data

		.word   COUT
		.dbyt	COUT
globdat		.long	65535

		.float	0, 1, 2
		.float	0.5

; Note expression is integer, then converted

		.float	5/2
		.float	1.41421356237

; Nested .if - .else - .endif

		.if	1
		.byte	$ff
		.if	0
		.byte	$ff
		.endif
		.byte	$ff
		.else
		.byte	$ff
		.endif

; Check assumptions

		.assert	2 + 2 == 4

; We can do this arithmetic on local symbols

		.dbyt	end_empty - start_empty

; String stuff -- ".hibit" affects these,
; except octal & hex escapes

		.asciz  "asfs\tdf"
		.ascii  "aa" "bb"
		.hibit	17 == 35/2
		.ascii	" \n\t\v\b\r\f\a"
		.ascii	"\e\\\"\033\x33"

; ".dci" is "dextral character inverted" a la Merlin

		.dci    "quite a long string my friend"
		.hibit	5%2!=1

; cut down on the clutter...

		.expand	0
		.ascii  "quite a long string my friend"

		.if	1 == 2
		.ascii	"this will not be emitted nor"
		.ascii	"will it be shown in the listing"
		.ascii	"because .expand is off"
		.endif

; BSS segment now

		.bss
start_empty 	.space  13
		.align	4
end_empty	.space	3

