# Part of the A-A-P recipe executive: Setup using MSVC
# Last Change: 2004 May 08

# Copyright (c) 2002-2003 stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

#
# This module sets up variables and actions for using the Microsoft Visual C
# compiler tools.
#

from RecPython import *
import Global
from Action import action_add
from Dictlist import str2dictlist
from RecPos import RecPos


def exists():
    """
    Return TRUE when the MSVC toolchain can be found.
    """
    return program_path("cl") or program_path("vcvars32")


def define_actions():
    """
    Define the actions that MSVC can accomplish.
    """
    rd = Global.globals

    cmd = ("defi = $?DEFINE\n"
            + "@defi = re.sub('-D', '/D', defi)\n"
            + "incl = $?INCLUDE\n"
            + "@incl = re.sub('-I', '/I', incl)\n")

    # TODO: use DEBUG and OPTIMIZE
    rpstack = [ RecPos("compile_msvc c action") ]
    action_add(rpstack, rd, str2dictlist(rpstack, "compile_msvc object,libobject c"),
            cmd + ":sys $MSVC $CPPFLAGS $defi $incl $CFLAGS /c $source /Fo$target")

    rpstack = [ RecPos("compile_msvc cpp action") ]
    action_add(rpstack, rd, str2dictlist(rpstack, "compile_msvc object,libobject cpp"),
            cmd + ":sys $MSVC $CPPFLAGS $defi $incl $CXXFLAGS /TP /c $source /Fo$target")

    if not rd.get("MSVC"):
        rd["MSVC"] = "cl"

    # Build action.
    # Change $LIBS from "-lname" to "name.lib".
    rpstack = [ RecPos("build_msvc action") ]
    action_add(rpstack, rd, str2dictlist(rpstack, "build_msvc object"),
            "libs = $?LIBS\n"
            "libs = `re.sub('(\\\\A| )-l', ' ', libs)`\n"
            "libs = `sufadd('.lib', libs)`\n"
            ":sys $MSLINK $LINKFLAGS /out:$target $source $libs")
    if not rd.get("MSLINK"):
        rd["MSLINK"] = "link"
    if not rd.get("LINKFLAGS"):
        rd["LINKFLAGS"] = "/nologo"


def use_actions(scope):
    """
    Setup variables so that the default actions use the MSVC actions.
    """
    scope["C_COMPILE_ACTION"] = "compile_msvc"
    scope["CXX_COMPILE_ACTION"] = "compile_msvc"
    scope["C_BUILD_ACTION"] = "build_msvc"
    scope["CXX_BUILD_ACTION"] = "build_msvc"

    # Avoid using gcc for dependency checks.  It may exist but won't work with
    # the MSVC compiler flags.
    scope["HASGCC"] = "no"
    scope["HASGCCXX"] = "no"

# vim: set sw=4 et sts=4 tw=79 fo+=l:
