# Part of the A-A-P GUI IDE: Debugger Activity class

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

#
# Would want to call this "Debugger" but that module already exists.
#

import os.path

from Activity import Activity
import Navigator
import DebugTool
import Tool

# TODO: do this properly with gettext().
def _(x):
    return x

class DebugProgram(Activity):
    """Debugger Activity."""

    def open(self):
        """Create a navigator for the debugger, add one item."""
        item = Navigator.ActyItem(self.name, '.', self, None)
        self.topmodel.nodelist.addNode(item.node)
        nav = Navigator.Navigator("Program", item)
        self.addNav(nav)

        Tool.runToolByName("DebugTool", item, "debug")


def getMenuText():
    """Return the name to be used for the "New Activity" menu and the
       status bar."""
    return _("Debugger"), _("Run a Debugger")


def create(topmodel):
    """Create a new DebugProgram Activity."""
    act = DebugProgram("none", topmodel)
    act.open()
    return act


def canOpen(name, type):
    """Return TRUE when "name" can be opened for this activity class.
       Recognize a program by that it has no filetype and is executable."""
    dict = DebugTool.canDoActionsName(name, type)
    return dict.has_key("debug")

# vim: set sw=4 et sts=4 tw=79 fo+=l:
