# Part of the A-A-P GUI IDE: single file Activity class

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

from Activity import Activity
import Navigator

# TODO: do this properly with gettext().
def _(x):
    return x

class File(Activity):
    """simple File Activity.  This falls back to the Activity class for nearly
       everything, it only exists to be able to open a new file."""

def getMenuText():
    """Return the name to be used for the "New Activity" menu."""
    return _("File"), _("Create a new File")


def create(topmodel):
    """Create a new activity.  The file is not created, let the editor write
       the file."""
    name = topmodel.view.fileDialog(_("Enter name for new file"))
    if not name:
        return None

    act = File(name, topmodel)
    act.open()
    return act


def canOpen(name, type):
    """Return TRUE when "name" can be opened for this activity class.
       We could actually open any file, but fall back to the default activity
       for that."""
    return 0

# vim: set sw=4 et sts=4 tw=79 fo+=l:
