# Part of the A-A-P GUI IDE: Python Shell Activity class

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

from Activity import Activity
import Navigator
import Tool

# TODO: do this properly with gettext().
def _(x):
    return x

class PythonShell(Activity):
    """Python Shell Activity."""

    def open(self):
        """Create a navigator for the new Activity, fill it with items from the
           recipe."""
        item = Navigator.ActyItem(self.name, '.', self, None)
        self.topmodel.nodelist.addNode(item.node)
        nav = Navigator.Navigator("Tool", item)
        self.addNav(nav)

        Tool.runToolByName("PythonShellTool", item, "shell")

def getMenuText():
    """Return the name to be used for the "New Activity" menu and the
       status bar."""
    return _("Python shell"), _("Open a new Python Shell window")


def create(topmodel):
    """Create a new Python shell Activity."""
    act = PythonShell("Python shell", topmodel)
    act.open()
    return act


def canOpen(name, type):
    """Return TRUE when "name" can be opened for this activity class."""
    return 0

# vim: set sw=4 et sts=4 tw=79 fo+=l:
