# Part of the A-A-P GUI IDE: The view for the list of actys

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

from wxPython.wx import *

# Define the IDs used below.
[
        wxID_ACTYLISTBOX,
      ] = map(lambda x: wxNewId(), range(1))


class ActyListView:
    def __init__(self, topframe, parent, actylist):
        self.topframe = topframe
        self.parent = parent
        self.actylist = actylist          # the ActyList we view here

        self.actylistbox = wxListBox(parent = parent,
                id = wxID_ACTYLISTBOX,
                style = wxLB_SINGLE | wxLB_NEEDED_SB)
        EVT_LISTBOX(topframe, wxID_ACTYLISTBOX, self.OnActySelected)

        parent.AddPage(self.actylistbox, 'Activities')

    def addActy(self, acty):
        """Add an acty to the view of the acty list."""
        self.actylistbox.Append(acty.getListString())
        i = len(self.actylist) - 1
        self.actylistbox.SetSelection(i)
        self.actylist.setCurrentActy(i)

    def delActy(self, i):
        """Delete an acty from the view of the acty list."""
        self.actylistbox.Delete(i)

    def updateRecent(self):
        """Called when the list of recent activities has changed."""
        self.topframe.updateRecent()

    def SetSelection(self, i):
        self.actylistbox.SetSelection(i)
        self.actylist.setCurrentActy(i)

    def OnActySelected(self, e):
        """Click in activity listbox."""
        self.actylist.setCurrentActy(e.GetSelection())

# vim: set sw=4 et sts=4 tw=79 fo+=l:
