# Part of the A-A-P GUI IDE: Handling of configuration options

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

import os.path
import string

from Util import *

def readConfig(topmodel):
    """Read the configuration file."""
    homedir = home_dir()
    if homedir:
        topmodel.configfname = os.path.join(homedir, "agide.cnf")
        if os.path.exists(topmodel.configfname):
            try:
                f = open(topmodel.configfname)
                while 1:
                    line = f.readline()
                    if not line:
                        break

                    # Ignore comment lines
                    if line[0] == '#':
                        continue

                    # Remove "\n" and split into first item and rest.
                    line = line[:-1]
                    items = string.split(line, '\033', 1)
                    if items[0] == "recentActy":
                        topmodel.actylist.insertRecent(items[1])
                    elif items[0] and items[1]:
                        topmodel.confdict[items[0]] = items[1]
                    else:
                        print ("Unrecognized item in config file: '%s'"
                                                                    % line)
                f.close()
            except StandardError, e:
                print "Error reading config file: " + str(e)


def get_conf_key(key, topmodel, default_dict):
    """Return the value of an option, if not defined return default."""
    if topmodel.confdict.has_key(key): 
        return topmodel.confdict[key]
    return default_dict[key]


def writeConfig(topmodel):
    """Write the configuration file."""
    if topmodel.configfname:
        dir = os.path.dirname(topmodel.configfname)
        if not os.path.exists(dir):
            try:
                os.makedirs(dir)
            except StandardError, e:
                print 'Error creating directory for config file "%s": %s' % (dir, str(e))
                return

	if not os.access(dir, os.W_OK):
            print "Skipped writing config file, directory is not writable: %s" % dir
            return

        try:
            f = open(topmodel.configfname, "wb")
            f.write("# Agide configuration file\n")
            f.write("# recent activities (oldest first)\n")
            list = topmodel.actylist.getRecentList()
            n = len(list)
            if n > 10:
                n = 10
            # write the list backwards, oldest first.
            for i in range(n, 0, -1):
                f.write("recentActy\033%s\n" % list[i - 1])
            for key in topmodel.confdict.keys():
                f.write("%s\033%s\n" % (key,topmodel.confdict[key]))
            f.close()
        except StandardError, e:
            print "Error writing config file: " + str(e)

