# Part of the A-A-P GUI IDE: The view for the list of nodes

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

from wxPython.wx import *

# Define the IDs used below.
[
        wxID_ITEMLISTBOX,
      ] = map(lambda x: wxNewId(), range(1))


class NodeListView:
    def __init__(self, topframe, parent, itemlist):
        self.topframe = topframe
        self.parent = parent
        self.itemlist = itemlist          # the ItemList we view here

        self.nodelistbox = wxListBox(parent = parent,
                id = wxID_ITEMLISTBOX,
                style = wxLB_SINGLE | wxLB_NEEDED_SB)
        EVT_LISTBOX(topframe, wxID_ITEMLISTBOX, self.OnItemSelected)

        parent.AddPage(self.nodelistbox, 'Items')

    def addNode(self, node):
        """Add a node to the view of the node list."""
        self.nodelistbox.Append(node.listName())
        self.nodelistbox.SetSelection(len(self.itemlist) - 1)

    def OnItemSelected(self, e):
        """Click in node listbox."""
        self.itemlist.getNode(e.GetSelection()).foreground()

    def delNode(self, idx):
        """Remove an item from the list."""
        self.nodelistbox.Delete(idx)

# vim: set sw=4 et sts=4 tw=79 fo+=l:
