#! /usr/bin/env python
# Part of the A-A-P GUI IDE: Define myrealpath()

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

# This function is in a separate file, because its syntax is invalid in Python
# 1.5.  Import this from inside a try/except!

import os.path

# Return a canonical path (i.e. the absolute location of a file on the
# filesystem).  This is from os.path of Python 2.2.
def myrealpath(filename):
    """Return the canonical path of the specified filename, eliminating any
    symbolic links encountered in the path."""
    filename = os.path.abspath(filename)

    bits = ['/'] + filename.split('/')[1:]
    for i in range(2, len(bits)+1):
        component = os.path.join(*bits[0:i])
        if os.path.islink(component):
            resolved = os.readlink(component)
            (dir, file) = os.path.split(component)
            resolved = os.path.normpath(os.path.join(dir, resolved))
            newpath = os.path.join(*([resolved] + bits[i:]))
            return myrealpath(newpath)

    return filename
