# Part of the A-A-P GUI IDE: The view for the list of tools

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

from wxPython.wx import *

# Define the IDs used below.
[
        wxID_TOOLLISTBOX,
      ] = map(lambda x: wxNewId(), range(1))


class ToolListView:
    def __init__(self, topframe, parent, toollist):
        self.topframe = topframe
        self.parent = parent
        self.toollist = toollist          # the ToolList we view here

        self.toollistbox = wxListBox(parent = parent,
                id = wxID_TOOLLISTBOX,
                style = wxLB_SINGLE | wxLB_NEEDED_SB)
        EVT_LISTBOX(topframe, wxID_TOOLLISTBOX, self.OnToolSelected)

        parent.AddPage(self.toollistbox, 'Tools')

    def addTool(self, tool):
        """Add a tool to the view of the tool list."""
        self.toollistbox.Append(tool.name)
        self.toollistbox.SetSelection(len(self.toollist) - 1)

    def delTool(self, i):
        """Delete a tool from the view of the tool list."""
        self.toollistbox.Delete(i)

    def setTool(self, i, tool):
        """Change the tool at position "i".  Used when its name changed."""
        self.toollistbox.InsertItems([ tool.name ], i)
        self.toollistbox.Delete(i + 1)

    def OnToolSelected(self, e):
        """Click in tool listbox."""
        self.toollist.getTool(e.GetSelection()).foreground(None)

# vim: set sw=4 et sts=4 tw=79 fo+=l:
