# Part of the A-A-P GUI IDE: Tool class for viewers

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING


# This Tool checks for view actions defined in Aap and makes them available in
# Agide.

from Tool import Tool
import Util
import Main

toollist = []       # Added to in Tool.py

# TODO: do this properly with gettext().
def _(x):
    return x

viewtypeslist = {}
edittypeslist = {}
did_fill_typeslist = 0

def getTypesList():
    """Use the Recipe Executive to find out which view actions are available
       there."""
    global did_fill_typeslist, viewtypeslist, edittypeslist
    if did_fill_typeslist:
        return
    did_fill_typeslist = 1

    # Use the Recipe Executive to obtain a list of all actions.
    # Filter out the "view" actions.
    dict = Main.get_actionlist()
    for act, list in [("view", viewtypeslist), ("edit", edittypeslist) ]:
        if dict.has_key(act):
            for intype in dict[act].keys():
                if intype != "default":
                    list[intype] = 1

def canDoActions(item, type):
    """Return a dictionary that describes how well this Tool can perform
       actions on ActyItem "item" with type "type"."""
    if not item.node:
        return {}
    getTypesList()
    res = {}
    if viewtypeslist.get(type):
        res["view"] = 50
    if edittypeslist.get(type):
        res["edit"] = 50
    return res

def getProperties(topmodel):
    """Properties that this kind of tool supports."""
    return {
            "start_async" : 1,
            }

def openItem(item, action, lnum = None, col = None, off = None):
    """Open ActyItem "item" in this Tool.  Creat a new Tool when there isn't
       one yet, otherwise return the existing one."""
    tool = ActionViewerTool("Action Viewer", item, action, lnum, col, off)
    item.acty.topmodel.toollist.addTool(tool)
    return tool


class ActionViewerTool(Tool):
    """Use an Aap view action to view a file."""
    def __init__(self, *args, **keyw):
        self.started = 0
        apply(Tool.__init__, (self,) + args, keyw)
        self.name = "%s %s" % (self.action, Util.display_name(self.itemlist[0].shortName()))

    def getProperties(self):
        """Properties that this tool supports."""
        return getProperties(self.topmodel)

    def close(self, shutdown):
        """Close the tool.
           Return non-zero if closing is OK."""
        # XXX try stopping a running Tool
        self.topmodel.toollist.delTool(self)
        return 1        # can shutdown

    def foreground(self, item, node = None, lnum = None):
        """Move this Tool to the foreground, with the current activity."""
        if item:
            self.setCurrentItem(item)
            node = item.node
        if node:
            if not self.started:
                Main.execute(":do %s {async} '%s'"
                                              % (self.action, node.fullName()))
                self.started = 1

        # XXX bring the Tool to the foreground.


# vim: set sw=4 et sts=4 tw=79 fo+=l:
