#Boa:Dialog:GrepToolDialog

# Part of the A-A-P GUI IDE: Dialog for the grep tool

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

from wxPython.wx import *

def create(parent):
    return GrepToolDialog(parent)

[wxID_GREPTOOLDIALOG, wxID_GREPTOOLDIALOGCANCELBUTTON, 
 wxID_GREPTOOLDIALOGGREPTEXT, wxID_GREPTOOLDIALOGIGNORECASECHECKBOX, 
 wxID_GREPTOOLDIALOGPATTERNBUTTON, wxID_GREPTOOLDIALOGSEARCHBUTTON, 
 wxID_GREPTOOLDIALOGSTATICTEXT1, wxID_GREPTOOLDIALOGTEXTBUTTON, 
 wxID_GREPTOOLDIALOGWORDBUTTON, 
] = map(lambda _init_ctrls: wxNewId(), range(9))

class GrepToolDialog(wxDialog):
    def _init_utils(self):
        # generated method, don't edit
        pass

    def _init_ctrls(self, prnt):
        # generated method, don't edit
        wxDialog.__init__(self, id=wxID_GREPTOOLDIALOG, name='', parent=prnt,
              pos=wxPoint(393, 340), size=wxSize(441, 236),
              style=wxDEFAULT_DIALOG_STYLE, title='Grep dialog')
        self._init_utils()
        self.SetClientSize(wxSize(441, 236))

        self.greptext = wxTextCtrl(id=wxID_GREPTOOLDIALOGGREPTEXT,
              name='greptext', parent=self, pos=wxPoint(112, 48),
              size=wxSize(288, 22), style=wxTE_PROCESS_ENTER, value='')
        EVT_TEXT_ENTER(self.greptext, wxID_GREPTOOLDIALOGGREPTEXT,
              self.OnGreptextEnter)

        self.textbutton = wxRadioButton(id=wxID_GREPTOOLDIALOGTEXTBUTTON,
              label='text', name='textbutton', parent=self, pos=wxPoint(128,
              80), size=wxSize(64, 24), style=0)
        self.textbutton.SetValue(true)
        self.textbutton.SetToolTipString('search for plain text')

        self.wordbutton = wxRadioButton(id=wxID_GREPTOOLDIALOGWORDBUTTON,
              label='word', name='wordbutton', parent=self, pos=wxPoint(200,
              80), size=wxSize(56, 24), style=0)
        self.wordbutton.SetValue(false)
        self.wordbutton.SetToolTipString('search for whole word')

        self.patternbutton = wxRadioButton(id=wxID_GREPTOOLDIALOGPATTERNBUTTON,
              label='pattern', name='patternbutton', parent=self,
              pos=wxPoint(272, 80), size=wxSize(64, 24), style=0)
        self.patternbutton.SetValue(false)
        self.patternbutton.SetToolTipString('search for a regular expression')

        self.staticText1 = wxStaticText(id=wxID_GREPTOOLDIALOGSTATICTEXT1,
              label='search for:', name='staticText1', parent=self,
              pos=wxPoint(40, 56), size=wxSize(59, 16), style=0)

        self.searchbutton = wxButton(id=wxID_GREPTOOLDIALOGSEARCHBUTTON,
              label='Search', name='searchbutton', parent=self, pos=wxPoint(128,
              184), size=wxSize(80, 22), style=0)
        EVT_BUTTON(self.searchbutton, wxID_GREPTOOLDIALOGSEARCHBUTTON,
              self.OnSearchbuttonButton)

        self.cancelbutton = wxButton(id=wxID_GREPTOOLDIALOGCANCELBUTTON,
              label='Cancel', name='cancelbutton', parent=self, pos=wxPoint(256,
              184), size=wxSize(80, 22), style=0)
        EVT_BUTTON(self.cancelbutton, wxID_GREPTOOLDIALOGCANCELBUTTON,
              self.OnCancelbuttonButton)

        self.ignorecasecheckbox = wxCheckBox(id=wxID_GREPTOOLDIALOGIGNORECASECHECKBOX,
              label='ignore case', name='ignorecasecheckbox', parent=self,
              pos=wxPoint(128, 112), size=wxSize(86, 24), style=0)
        self.ignorecasecheckbox.SetValue(false)

    def __init__(self, parent):
        self._init_ctrls(parent)

    def getText(self):
        """Obtain the text the user entered."""
        return self.greptext.GetValue()

    def setText(self, text):
        self.greptext.SetValue(text)
        self.greptext.SetInsertionPointEnd()
        self.greptext.SetSelection(-1, -1)  # XXX doesn't seem to work...

    def getType(self):
        """Obtain the type the user selected."""
        if self.textbutton.GetValue():
            return "text"
        if self.wordbutton.GetValue():
            return "word"
        return "pattern"

    def setType(self, type):
        self.textbutton.SetValue(type == "text")
        self.wordbutton.SetValue(type == "word")
        self.patternbutton.SetValue(type == "pattern")

    def getCase(self):
        """Obtain case matching; "match" or "ignore"."""
        if self.ignorecasecheckbox.GetValue():
            return "ignore"
        return "match"

    def setCase(self, case):
        self.ignorecasecheckbox.SetValue(case == "ignore")

    def OnSearchbuttonButton(self, event):
        self.EndModal(wxID_OK)

    def OnCancelbuttonButton(self, event):
        self.EndModal(wxID_CANCEL)

    def OnGreptextEnter(self, event):
        self.EndModal(wxID_OK)


def doDialog(view, settings = {}):
    """Show the dialog and return a dictionary with the grep settings."""
    res = {}
    dlg = GrepToolDialog(view)
    if settings.get("text"):
        dlg.setText(settings["text"])
    if settings.get("type"):
        dlg.setType(settings["type"])
    if settings.get("case"):
        dlg.setCase(settings["case"])

    if dlg.ShowModal() == wxID_OK:
        res["text"] = dlg.getText()
        res["type"] = dlg.getType()
        res["case"] = dlg.getCase()
    dlg.Destroy()
    return res

# vim: set sw=4 et sts=4 tw=79 fo+=l:
