# Part of the A-A-P GUI IDE: Navigation Tree, part of the GUI

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

from wxPython.wx import *

import Util

# TODO: do this properly with gettext().
def _(x):
    return x


[wxID_GREPTOOLWINDOW, wxID_GREPTOOLWINDOWGREPLIST, 
] = map(lambda _init_ctrls: wxNewId(), range(2))

[wxID_GREPTOOLWINDOWGREPMENUSEARCHAGAIN,
wxID_GREPTOOLWINDOWGREPMENUCLOSE] = map(lambda _init_coll_grepmenu_Items: wxNewId(), range(2))

class GrepToolWindow(wxFrame):
    def _init_coll_grepmenu_Items(self, parent):
        parent.Append(helpString='',
                id=wxID_GREPTOOLWINDOWGREPMENUSEARCHAGAIN, item='Search again')
        EVT_MENU(self, wxID_GREPTOOLWINDOWGREPMENUSEARCHAGAIN,
              self.OnGrepmenuSearchAgain)

        parent.Append(helpString='',
                             id=wxID_GREPTOOLWINDOWGREPMENUCLOSE, item='Close')
        EVT_MENU(self, wxID_GREPTOOLWINDOWGREPMENUCLOSE,
              self.OnGrepmenuClose)

    def _init_utils(self):
        self.menubar = wxMenuBar()

        self.grepmenu = wxMenu()
        self._init_coll_grepmenu_Items(self.grepmenu)
        self.menubar.Append(self.grepmenu, _("&Grep"))
        self.SetMenuBar(self.menubar)

    def _init_ctrls(self, prnt):
        from GUItop import toplevel_xpos, toplevel_ypos, toplevel_height, border_height, grep_width, grep_height
        wxFrame.__init__(self, id=wxID_GREPTOOLWINDOW, name='', parent=prnt,
              pos=wxPoint(toplevel_xpos, toplevel_ypos + toplevel_height + border_height),
              size=wxSize(grep_width, grep_height),
              style=wxDEFAULT_FRAME_STYLE, title='grep tool results')
        self._init_utils()

        self.greplist = wxListCtrl(id=wxID_GREPTOOLWINDOWGREPLIST,
              name='greplist', parent=self, pos=wxPoint(0, 0), size=wxSize(532,
              370), style=wxLC_REPORT, validator=wxDefaultValidator)

    def __init__(self, parent, tool):
        self._init_ctrls(parent)
        self.tool = tool
        EVT_CLOSE(self, self.OnWindowClose)
        EVT_LIST_ITEM_ACTIVATED(self, wxID_GREPTOOLWINDOWGREPLIST,
                                                          self.OnItemActivated)

    def OnGrepmenuSearchAgain(self, event):
        self.tool.again()

    def OnGrepmenuClose(self, event):
        self.Close()

    def OnItemActivated(self, event):
        self.tool.entryActivated(event.m_itemIndex)

    def OnWindowClose(self, event):
        """Let the tool know our window was closed."""
        self.tool.windowClosed()
        self.Destroy()

    def setList(self, list, rootdir):
        """Fill the list with items."""
        self.greplist.ClearAll()
        self.greplist.InsertColumn(0, "Item", width = 100)
        self.greplist.InsertColumn(1, "Line", width = 40)
        self.greplist.InsertColumn(2, "Text", width = 1000)
        idx = 0
        for itempos in list:
            fname = Util.shorten_name(itempos.item.node.fullName(), rootdir)
            self.greplist.InsertStringItem(idx, fname)
            self.greplist.SetStringItem(idx, 1, "%d" % itempos.lnum)
            self.greplist.SetStringItem(idx, 2, itempos.text)
            idx = idx + 1
        self.Show()


# vim: set sw=4 et sts=4 tw=79 fo+=l:
