# Part of the A-A-P GUI IDE: Tool class for a Python shell

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

from Tool import Tool
import Util
import RecPython

toollist = []       # Added to in Tool.py

# TODO: do this properly with gettext().
def _(x):
    return x

def canDoActions(name, type):
    """Return a dictionary that describes how well this Tool can perform
       actions on file "name" with type "type"."""
    return {}

boa_found = -1      # 0 when check didn't find it, 1 when it exists.

def boa_exists():
    """Check if there is a boa program somewhere."""
    global boa_found
    if boa_found < 0:
        if RecPython.program_path("boa"):
            boa_found = 1
        else:
            boa_found = 0
    return boa_found

def getProperties(topmodel):
    """Properties that this kind of tool supports."""
    if boa_exists():
        return {
                "start_async" : 1,
                }
    return {}

def openItem(item, action, lnum = None, col = None, off = None):
    """Open ActyItem "item" in this Tool.  Creat a new Tool when there isn't
       one yet, otherwise return the existing one."""
    # Actually, we ignore the item here....
    tool = PythonShellTool("Python shell", item, action)
    item.acty.topmodel.toollist.addTool(tool)
    return tool


class PythonShellTool(Tool):

    def __init__(self, *args, **keyw):
        apply(Tool.__init__, (self,) + args, keyw)
        self.boa_started = 0

        # Do nothing until foreground() is called.

    def getProperties(self):
        """Properties that this tool supports."""
        return getProperties(self.topmodel)

    def close(self, shutdown):
        """Close the tool.
           Return non-zero if shutdown is OK."""
        # Send Boa a request to close?
        self.topmodel.toollist.delTool(self)
        return 1        # can shutdown

    def foreground(self, item, node = None, lnum = None):
        """Move this activity to the foreground."""
        # Boa is started only once.  If you close it, it's gone until you open
        # a new shell.
        if not self.boa_started:
            self.boa_started = 1
            Util.async_system([], None, '{quiet} boa')

        # There should not really be an item here, but anyway...
        if item:
            self.setCurrentItem(item)
        else:
            self.currentnode = node

# vim: set sw=4 et sts=4 tw=79 fo+=l:
