#! /usr/bin/env python
# Part of the A-A-P GUI IDE: pychecker support file

# Copyright (C) 2002-2003 Stichting NLnet Labs
# Permission to copy and use this file is specified in the file COPYING.
# If this file is missing you can find it here: http://www.a-a-p.org/COPYING

#
# This file is used to run pychecker on the Agide source files.
# This doesn't work in the usual way, because the Python search patch must
# first be adjusted to find all the modules.
#

import sys
import os.path
from glob import glob
import re
import string

# We need to know the location of our modules.  Need to use an absolute
# path, we might change directories.
try:
    rootdir = os.path.dirname(os.path.realpath(sys.argv[0]))
except:
    # Doesn't have os.path.realpath(), it's new in Python 2.2
    rootdir = os.path.dirname(os.path.abspath(sys.argv[0]))

# When started with a relative path and changing directories we still need
# to be able to find our modules.
sys.path.append(rootdir)

# Search for Recipe Executive modules in a specific directory.
sys.path.append(os.path.join(os.path.dirname(rootdir), "Exec"))

# Search for Activity classes in a subdirectory.
sys.path.append(os.path.join(rootdir, "Activities"))

# Search for Tool classes in a subdirectory.
sys.path.append(os.path.join(rootdir, "Tools"))

import pychecker.checker

# Import all the modules, so that they are checked.

for n in glob("*.py"):
    if n != "check.py":
        exec "import " + n[:-3]

for n in glob("*/*.py"):
    n = n[string.find(n, "/") + 1:-3]
    print "import " + n
    exec "import " + n

for n in glob("*/*/*.py"):
    n = n[string.find(n, "/") + 1:-3]
    n = re.sub("/", ".", n)
    print "import " + n
    exec "import " + n

